/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

public class PartitioningSettings {
    private final long minActivePartitions;
    private final long partitionCountLimit;

    private PartitioningSettings(Builder builder) {
        this.minActivePartitions = builder.minActivePartitions;
        this.partitionCountLimit = builder.partitionCountLimit;
    }

    public long getMinActivePartitions() {
        return this.minActivePartitions;
    }

    public long getPartitionCountLimit() {
        return this.partitionCountLimit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long minActivePartitions = 0L;
        private long partitionCountLimit = 0L;

        public Builder setMinActivePartitions(long minActivePartitions) {
            this.minActivePartitions = minActivePartitions;
            return this;
        }

        public Builder setPartitionCountLimit(long partitionCountLimit) {
            this.partitionCountLimit = partitionCountLimit;
            return this;
        }

        public PartitioningSettings build() {
            return new PartitioningSettings(this);
        }
    }
}

