/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.topic.description.SupportedCodecs;

public class AlterConsumerSettings {
    private final String name;
    @Nullable
    private final Boolean important;
    @Nullable
    private final Instant readFrom;
    @Nullable
    private final SupportedCodecs supportedCodecs;
    private final Map<String, String> alterAttributes;
    private final Set<String> dropAttributes;

    private AlterConsumerSettings(Builder builder) {
        this.name = builder.name;
        this.important = builder.important;
        this.readFrom = builder.readFrom;
        this.supportedCodecs = builder.supportedCodecs;
        this.alterAttributes = builder.alterAttributes;
        this.dropAttributes = builder.dropAttributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getImportant() {
        return this.important;
    }

    @Nullable
    public Instant getReadFrom() {
        return this.readFrom;
    }

    @Nullable
    public SupportedCodecs getSupportedCodecs() {
        return this.supportedCodecs;
    }

    public Map<String, String> getAlterAttributes() {
        return this.alterAttributes;
    }

    public Set<String> getDropAttributes() {
        return this.dropAttributes;
    }

    public static class Builder {
        private String name;
        private Boolean important = null;
        private Instant readFrom = null;
        private SupportedCodecs supportedCodecs = null;
        private Map<String, String> alterAttributes = new HashMap<String, String>();
        private Set<String> dropAttributes = new HashSet<String>();

        public Builder setName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public Builder setImportant(boolean important) {
            this.important = important;
            return this;
        }

        public Builder setReadFrom(Instant readFrom) {
            this.readFrom = readFrom;
            return this;
        }

        public Builder setSupportedCodecs(SupportedCodecs supportedCodecs) {
            this.supportedCodecs = supportedCodecs;
            return this;
        }

        public Builder addAlterAttribute(@Nonnull String name, @Nonnull String value) {
            this.alterAttributes.put(name, value);
            return this;
        }

        public Builder setAlterAttributes(Map<String, String> attributes) {
            this.alterAttributes = attributes;
            return this;
        }

        public Builder addDropAttribute(@Nonnull String name) {
            this.dropAttributes.add(name);
            return this;
        }

        public Builder setDropAttributes(Set<String> attributes) {
            this.dropAttributes = attributes;
            return this;
        }

        public AlterConsumerSettings build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Consumer name is not set in AlterConsumerSettings");
            }
            return new AlterConsumerSettings(this);
        }
    }
}

