/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tech.ydb.topic.description.Codec;

public class SupportedCodecs {
    private final List<Codec> codecs;

    public SupportedCodecs(Builder builder) {
        this.codecs = ImmutableList.copyOf((Collection)builder.codecs);
    }

    public SupportedCodecs(List<Codec> codecs) {
        this.codecs = codecs;
    }

    public List<Codec> getCodecs() {
        return this.codecs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Codec> codecs = new ArrayList<Codec>();

        public Builder addCodec(Codec codec) {
            this.codecs.add(codec);
            return this;
        }

        public Builder setCodecs(List<Codec> supportedCodecs) {
            this.codecs = supportedCodecs;
            return this;
        }

        public SupportedCodecs build() {
            return new SupportedCodecs(this);
        }
    }
}

