/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import javax.annotation.Nullable;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.description.MultipleWindowsStat;
import tech.ydb.topic.description.OffsetsRange;
import tech.ydb.topic.read.impl.OffsetsRangeImpl;

public class PartitionStats {
    private final OffsetsRange partitionOffsets;
    private final long storeSizeBytes;
    private final Instant lastWriteTime;
    @Nullable
    private final java.time.Duration maxWriteTimeLag;
    private final MultipleWindowsStat bytesWritten;
    private final int partitionNodeId;

    public PartitionStats(YdbTopic.PartitionStats stats) {
        this.partitionOffsets = new OffsetsRangeImpl(stats.getPartitionOffsets().getStart(), stats.getPartitionOffsets().getEnd());
        this.storeSizeBytes = stats.getStoreSizeBytes();
        this.lastWriteTime = ProtobufUtils.protoToInstant((Timestamp)stats.getLastWriteTime());
        this.maxWriteTimeLag = ProtobufUtils.protoToDuration((Duration)stats.getMaxWriteTimeLag());
        this.bytesWritten = new MultipleWindowsStat(stats.getBytesWritten().getPerMinute(), stats.getBytesWritten().getPerHour(), stats.getBytesWritten().getPerDay());
        this.partitionNodeId = stats.getPartitionNodeId();
    }

    @Deprecated
    private PartitionStats(Builder builder) {
        this.partitionOffsets = builder.partitionOffsets;
        this.storeSizeBytes = builder.storeSizeBytes;
        this.lastWriteTime = builder.lastWriteTime;
        this.maxWriteTimeLag = builder.maxWriteTimeLag;
        this.bytesWritten = builder.bytesWritten;
        this.partitionNodeId = builder.partitionNodeId;
    }

    public OffsetsRange getPartitionOffsets() {
        return this.partitionOffsets;
    }

    public long getStoreSizeBytes() {
        return this.storeSizeBytes;
    }

    public Instant getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Nullable
    public java.time.Duration getMaxWriteTimeLag() {
        return this.maxWriteTimeLag;
    }

    public MultipleWindowsStat getBytesWritten() {
        return this.bytesWritten;
    }

    @Deprecated
    public int getPartitionNodeId() {
        return this.partitionNodeId;
    }

    @Deprecated
    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static class Builder {
        private OffsetsRange partitionOffsets;
        private long storeSizeBytes;
        private Instant lastWriteTime;
        private java.time.Duration maxWriteTimeLag = null;
        private MultipleWindowsStat bytesWritten;
        private int partitionNodeId;

        public Builder setPartitionOffsets(OffsetsRange partitionOffsets) {
            this.partitionOffsets = partitionOffsets;
            return this;
        }

        public Builder setStoreSizeBytes(long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
            return this;
        }

        public Builder setLastWriteTime(Instant lastWriteTime) {
            this.lastWriteTime = lastWriteTime;
            return this;
        }

        public Builder setMaxWriteTimeLag(java.time.Duration maxWriteTimeLag) {
            this.maxWriteTimeLag = maxWriteTimeLag;
            return this;
        }

        public Builder setBytesWritten(MultipleWindowsStat bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public Builder setPartitionNodeId(int partitionNodeId) {
            this.partitionNodeId = partitionNodeId;
            return this;
        }

        public PartitionStats build() {
            return new PartitionStats(this);
        }
    }
}

