/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.write.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import tech.ydb.topic.TopicRpc;
import tech.ydb.topic.settings.SendSettings;
import tech.ydb.topic.settings.WriterSettings;
import tech.ydb.topic.write.AsyncWriter;
import tech.ydb.topic.write.InitResult;
import tech.ydb.topic.write.Message;
import tech.ydb.topic.write.QueueOverflowException;
import tech.ydb.topic.write.WriteAck;
import tech.ydb.topic.write.impl.WriterImpl;

public class AsyncWriterImpl
extends WriterImpl
implements AsyncWriter {
    public AsyncWriterImpl(TopicRpc topicRpc, WriterSettings settings, Executor compressionExecutor) {
        super(topicRpc, settings, compressionExecutor);
    }

    @Override
    public CompletableFuture<InitResult> init() {
        return this.initImpl();
    }

    @Override
    public CompletableFuture<WriteAck> send(Message message, SendSettings settings) throws QueueOverflowException {
        try {
            return this.sendImpl(message, settings, true).join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof QueueOverflowException) {
                throw (QueueOverflowException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<WriteAck> send(Message message) throws QueueOverflowException {
        return this.send(message, null);
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return this.shutdownImpl();
    }
}

