/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.utils;

import tech.ydb.topic.description.Codec;

public class ProtoUtils {
    private ProtoUtils() {
    }

    public static int toProto(Codec codec) {
        switch (codec) {
            case RAW: {
                return 1;
            }
            case GZIP: {
                return 2;
            }
            case LZOP: {
                return 3;
            }
            case ZSTD: {
                return 4;
            }
            case CUSTOM: {
                return 10000;
            }
        }
        throw new RuntimeException("Cannot convert codec to proto. Unknown codec value: " + (Object)((Object)codec));
    }

    public static Codec codecFromProto(int codec) {
        switch (codec) {
            case 1: {
                return Codec.RAW;
            }
            case 2: {
                return Codec.GZIP;
            }
            case 3: {
                return Codec.LZOP;
            }
            case 4: {
                return Codec.ZSTD;
            }
            case 10000: {
                return Codec.CUSTOM;
            }
        }
        throw new RuntimeException("Unknown codec value from proto: " + codec);
    }
}

