/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import tech.ydb.topic.description.OffsetsRange;
import tech.ydb.topic.read.impl.OffsetsRangeImpl;

public class DisjointOffsetRangeSet {
    private final NavigableMap<Long, OffsetsRangeImpl> ranges = new TreeMap<Long, OffsetsRangeImpl>();

    public void add(OffsetsRange rangeToCommit) {
        Map.Entry<Long, OffsetsRangeImpl> ceilingEntry;
        Map.Entry<Long, OffsetsRangeImpl> floorEntry = this.ranges.floorEntry(rangeToCommit.getStart());
        if (floorEntry != null && floorEntry.getValue().getEnd() > rangeToCommit.getStart()) {
            this.throwClashesException(floorEntry.getValue(), rangeToCommit);
        }
        if ((ceilingEntry = this.ranges.ceilingEntry(rangeToCommit.getStart())) != null && rangeToCommit.getEnd() > ceilingEntry.getValue().getStart()) {
            this.throwClashesException(ceilingEntry.getValue(), rangeToCommit);
        }
        boolean mergedFloor = false;
        if (floorEntry != null && floorEntry.getValue().getEnd() == rangeToCommit.getStart()) {
            floorEntry.getValue().setEnd(rangeToCommit.getEnd());
            mergedFloor = true;
        }
        if (ceilingEntry != null) {
            OffsetsRangeImpl ceilingValue = ceilingEntry.getValue();
            if (rangeToCommit.getEnd() == ceilingValue.getStart()) {
                this.ranges.remove(ceilingEntry.getKey());
                if (mergedFloor) {
                    floorEntry.getValue().setEnd(ceilingValue.getEnd());
                } else {
                    ceilingValue.setStart(rangeToCommit.getStart());
                    this.ranges.put(rangeToCommit.getStart(), ceilingValue);
                }
                return;
            }
        }
        if (!mergedFloor) {
            this.ranges.put(rangeToCommit.getStart(), new OffsetsRangeImpl(rangeToCommit));
        }
    }

    public List<OffsetsRange> getRangesAndClear() {
        Collection values = this.ranges.values();
        ArrayList<OffsetsRange> result = new ArrayList<OffsetsRange>(values);
        values.clear();
        return result;
    }

    private void throwClashesException(OffsetsRangeImpl existingRange, OffsetsRange newRange) {
        String errMessage = "Error adding new offset range. Added range [" + newRange.getStart() + "," + newRange.getEnd() + ") clashes with existing range [" + existingRange.getStart() + "," + existingRange.getEnd() + ")";
        throw new RuntimeException(errMessage);
    }
}

