/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.topic.description.Consumer;
import tech.ydb.topic.description.MeteringMode;
import tech.ydb.topic.description.PartitionInfo;
import tech.ydb.topic.description.SupportedCodecs;
import tech.ydb.topic.description.TopicStats;
import tech.ydb.topic.settings.PartitioningSettings;

public class TopicDescription {
    private final PartitioningSettings partitioningSettings;
    private final List<PartitionInfo> partitions;
    @Nullable
    private final Duration retentionPeriod;
    private final long retentionStorageMb;
    private final SupportedCodecs supportedCodecs;
    private final long partitionWriteSpeedBytesPerSecond;
    private final long partitionWriteBurstBytes;
    private final Map<String, String> attributes;
    private final List<Consumer> consumers;
    private final MeteringMode meteringMode;
    private final TopicStats topicStats;

    private TopicDescription(Builder builder) {
        this.partitioningSettings = builder.partitioningSettings;
        this.partitions = ImmutableList.copyOf((Collection)builder.partitions);
        this.retentionPeriod = builder.retentionPeriod;
        this.retentionStorageMb = builder.retentionStorageMb;
        this.supportedCodecs = builder.supportedCodecs;
        this.partitionWriteSpeedBytesPerSecond = builder.partitionWriteSpeedBytesPerSecond;
        this.partitionWriteBurstBytes = builder.partitionWriteBurstBytes;
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
        this.consumers = ImmutableList.copyOf((Collection)builder.consumers);
        this.meteringMode = builder.meteringMode;
        this.topicStats = builder.topicStats;
    }

    public PartitioningSettings getPartitioningSettings() {
        return this.partitioningSettings;
    }

    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    @Nullable
    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public long getRetentionStorageMb() {
        return this.retentionStorageMb;
    }

    public SupportedCodecs getSupportedCodecs() {
        return this.supportedCodecs;
    }

    public long getPartitionWriteSpeedBytesPerSecond() {
        return this.partitionWriteSpeedBytesPerSecond;
    }

    public long getPartitionWriteBurstBytes() {
        return this.partitionWriteBurstBytes;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<Consumer> getConsumers() {
        return this.consumers;
    }

    public MeteringMode getMeteringMode() {
        return this.meteringMode;
    }

    public TopicStats getTopicStats() {
        return this.topicStats;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PartitioningSettings partitioningSettings;
        private List<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        private Duration retentionPeriod = null;
        private long retentionStorageMb;
        private SupportedCodecs supportedCodecs;
        private long partitionWriteSpeedBytesPerSecond;
        private long partitionWriteBurstBytes;
        private Map<String, String> attributes;
        private List<Consumer> consumers;
        private MeteringMode meteringMode;
        private TopicStats topicStats;

        public Builder setPartitioningSettings(PartitioningSettings partitioningSettings) {
            this.partitioningSettings = partitioningSettings;
            return this;
        }

        public Builder setPartitions(List<PartitionInfo> partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder setRetentionPeriod(Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Builder setRetentionStorageMb(long retentionStorageMb) {
            this.retentionStorageMb = retentionStorageMb;
            return this;
        }

        public Builder setSupportedCodecs(SupportedCodecs supportedCodecs) {
            this.supportedCodecs = supportedCodecs;
            return this;
        }

        public Builder setPartitionWriteSpeedBytesPerSecond(long partitionWriteSpeedBytesPerSecond) {
            this.partitionWriteSpeedBytesPerSecond = partitionWriteSpeedBytesPerSecond;
            return this;
        }

        public Builder setPartitionWriteBurstBytes(long partitionWriteBurstBytes) {
            this.partitionWriteBurstBytes = partitionWriteBurstBytes;
            return this;
        }

        public Builder addAttribute(@Nonnull String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder addConsumer(Consumer consumer) {
            this.consumers.add(consumer);
            return this;
        }

        public Builder setConsumers(List<Consumer> consumers) {
            this.consumers = consumers;
            return this;
        }

        public Builder setMeteringMode(MeteringMode meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        public Builder setTopicStats(TopicStats topicStats) {
            this.topicStats = topicStats;
            return this;
        }

        public TopicDescription build() {
            return new TopicDescription(this);
        }
    }
}

