/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.topic.description.ConsumerStats;
import tech.ydb.topic.description.SupportedCodecs;

public class Consumer {
    private final String name;
    @Nullable
    private final Boolean important;
    @Nullable
    private final Instant readFrom;
    @Nullable
    private final SupportedCodecs supportedCodecs;
    private final Map<String, String> attributes;
    @Nullable
    private final ConsumerStats stats;

    private Consumer(Builder builder) {
        this.name = builder.name;
        this.important = builder.important;
        this.readFrom = builder.readFrom;
        this.supportedCodecs = builder.supportedCodecs;
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
        this.stats = builder.stats;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean isImportant() {
        return this.important;
    }

    @Nullable
    public Instant getReadFrom() {
        return this.readFrom;
    }

    @Nullable
    public SupportedCodecs getSupportedCodecs() {
        return this.supportedCodecs;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public ConsumerStats getStats() {
        return this.stats;
    }

    public static class Builder {
        private String name;
        private Boolean important = null;
        private Instant readFrom = null;
        private SupportedCodecs supportedCodecs = null;
        private Map<String, String> attributes = new HashMap<String, String>();
        private ConsumerStats stats = null;

        public Builder setName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public Builder setImportant(boolean important) {
            this.important = important;
            return this;
        }

        public Builder setReadFrom(Instant readFrom) {
            this.readFrom = readFrom;
            return this;
        }

        public Builder setSupportedCodecs(SupportedCodecs supportedCodecs) {
            this.supportedCodecs = supportedCodecs;
            return this;
        }

        public Builder addAttribute(@Nonnull String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setStats(ConsumerStats stats) {
            this.stats = stats;
            return this;
        }

        public Consumer build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Consumer name is not set");
            }
            return new Consumer(this);
        }
    }
}

