/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import tech.ydb.topic.description.Codec;

public class WriterSettings {
    private static final long MAX_MEMORY_USAGE_BYTES_DEFAULT = 0x1400000L;
    private static final int MAX_IN_FLIGHT_COUNT_DEFAULT = 100000;
    private final String topicPath;
    private final String producerId;
    private final String messageGroupId;
    private final Long partitionId;
    private final Codec codec;
    private final long maxSendBufferMemorySize;
    private final int maxSendBufferMessagesCount;

    private WriterSettings(Builder builder) {
        this.topicPath = builder.topicPath;
        this.producerId = builder.producerId;
        this.messageGroupId = builder.messageGroupId;
        this.partitionId = builder.partitionId;
        this.codec = builder.codec;
        this.maxSendBufferMemorySize = builder.maxSendBufferMemorySize;
        this.maxSendBufferMessagesCount = builder.maxSendBufferMessagesCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTopicPath() {
        return this.topicPath;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String getMessageGroupId() {
        return this.messageGroupId;
    }

    public Long getPartitionId() {
        return this.partitionId;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public long getMaxSendBufferMemorySize() {
        return this.maxSendBufferMemorySize;
    }

    public int getMaxSendBufferMessagesCount() {
        return this.maxSendBufferMessagesCount;
    }

    public static class Builder {
        private String topicPath = null;
        private String producerId = null;
        private String messageGroupId = null;
        private Long partitionId = null;
        private Codec codec = Codec.GZIP;
        private long maxSendBufferMemorySize = 0x1400000L;
        private int maxSendBufferMessagesCount = 100000;

        public Builder setTopicPath(String topicPath) {
            this.topicPath = topicPath;
            return this;
        }

        public Builder setProducerId(String producerId) {
            this.producerId = producerId;
            return this;
        }

        public Builder setMessageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public Builder setPartitionId(long partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public Builder setCodec(Codec codec) {
            this.codec = codec;
            return this;
        }

        public Builder setMaxSendBufferMemorySize(long maxMemoryUsageBytes) {
            this.maxSendBufferMemorySize = maxMemoryUsageBytes;
            return this;
        }

        public Builder setMaxSendBufferMessagesCount(int maxMessagesCount) {
            this.maxSendBufferMessagesCount = maxMessagesCount;
            return this;
        }

        public WriterSettings build() {
            return new WriterSettings(this);
        }
    }
}

