/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.description;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tech.ydb.topic.description.PartitionStats;

public class PartitionInfo {
    private final long partitionId;
    private final boolean active;
    private final List<Long> childPartitionIds;
    private final List<Long> parentPartitionIds;
    private final PartitionStats partitionStats;

    private PartitionInfo(Builder builder) {
        this.partitionId = builder.partitionId;
        this.active = builder.active;
        this.childPartitionIds = ImmutableList.copyOf((Collection)builder.childPartitionIds);
        this.parentPartitionIds = ImmutableList.copyOf((Collection)builder.parentPartitionIds);
        this.partitionStats = builder.partitionStats;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<Long> getChildPartitionIds() {
        return this.childPartitionIds;
    }

    public List<Long> getParentPartitionIds() {
        return this.parentPartitionIds;
    }

    public PartitionStats getPartitionStats() {
        return this.partitionStats;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long partitionId;
        private boolean active;
        private List<Long> childPartitionIds = new ArrayList<Long>();
        private List<Long> parentPartitionIds = new ArrayList<Long>();
        private PartitionStats partitionStats;

        public Builder setPartitionId(long partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setChildPartitionIds(List<Long> childPartitionIds) {
            this.childPartitionIds = childPartitionIds;
            return this;
        }

        public Builder setParentPartitionIds(List<Long> parentPartitionIds) {
            this.parentPartitionIds = parentPartitionIds;
            return this;
        }

        public Builder setPartitionStats(PartitionStats partitionStats) {
            this.partitionStats = partitionStats;
            return this;
        }

        public PartitionInfo build() {
            return new PartitionInfo(this);
        }
    }
}

