/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;

public class TopicReadSettings {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private final String path;
    private final List<Long> partitionIds;
    private final Duration maxLag;
    private final Instant readFrom;
    private final Duration connectTimeout;

    private TopicReadSettings(Builder builder) {
        this.path = builder.path;
        this.partitionIds = builder.partitionIds;
        this.maxLag = builder.maxLag;
        this.readFrom = builder.readFrom;
        this.connectTimeout = builder.connectTimeout;
    }

    public String getPath() {
        return this.path;
    }

    public List<Long> getPartitionIds() {
        return this.partitionIds;
    }

    @Nullable
    public Duration getMaxLag() {
        return this.maxLag;
    }

    @Nullable
    public Instant getReadFrom() {
        return this.readFrom;
    }

    @Nullable
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String path = null;
        private List<Long> partitionIds = null;
        private Duration maxLag = null;
        private Instant readFrom = null;
        private Duration connectTimeout = null;

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setPartitionIds(List<Long> partitionIds) {
            this.partitionIds = partitionIds;
            return this;
        }

        public Builder setMaxLag(Duration maxLag) {
            this.maxLag = maxLag;
            return this;
        }

        public Builder setReadFrom(Instant readFrom) {
            this.readFrom = readFrom;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public TopicReadSettings build() {
            if (this.path == null || this.path.isEmpty()) {
                throw new IllegalArgumentException("Missing path for topic read settings");
            }
            return new TopicReadSettings(this);
        }
    }
}

