/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl.events;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.topic.read.Message;
import tech.ydb.topic.read.PartitionSession;
import tech.ydb.topic.read.events.DataReceivedEvent;

public class DataReceivedEventImpl
implements DataReceivedEvent {
    private static final Logger logger = LoggerFactory.getLogger(DataReceivedEventImpl.class);
    private final List<Message> messages;
    private final PartitionSession partitionSession;
    private final Supplier<CompletableFuture<Void>> commitCallback;

    public DataReceivedEventImpl(List<Message> messages, PartitionSession partitionSession, Supplier<CompletableFuture<Void>> commitCallback) {
        this.messages = messages;
        this.partitionSession = partitionSession;
        this.commitCallback = commitCallback;
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    public PartitionSession getPartitionSession() {
        return this.partitionSession;
    }

    @Override
    public CompletableFuture<Void> commit() {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}] partition session {} (partition {}): committing batch with {} message(s) and offsets {}-{}", new Object[]{this.partitionSession.getPath(), this.partitionSession.getId(), this.partitionSession.getPartitionId(), this.messages.size(), this.messages.get(0).getOffset(), this.messages.get(this.messages.size() - 1).getOffset()});
        }
        return this.commitCallback.get();
    }
}

