/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.TopicRpc;

public class ReadSession {
    private static final Logger logger = LoggerFactory.getLogger(ReadSession.class);
    private final GrpcReadWriteStream<YdbTopic.StreamReadMessage.FromServer, YdbTopic.StreamReadMessage.FromClient> streamConnection;
    private final AtomicBoolean isWorking = new AtomicBoolean(true);
    private String token;

    public ReadSession(TopicRpc rpc) {
        this.streamConnection = rpc.readSession();
        this.token = this.streamConnection.authToken();
    }

    public synchronized CompletableFuture<Status> start(GrpcReadStream.Observer<YdbTopic.StreamReadMessage.FromServer> streamObserver) {
        logger.info("ReadSession start");
        return this.streamConnection.start(message -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Message received:\n{}", message);
            } else {
                logger.debug("Message received");
            }
            if (this.isWorking.get()) {
                streamObserver.onNext(message);
            }
        });
    }

    public synchronized void send(YdbTopic.StreamReadMessage.FromClient request) {
        if (!this.isWorking.get()) {
            if (logger.isTraceEnabled()) {
                logger.trace("ReadSession is already closed. This message is NOT sent:\n{}", (Object)request);
            }
            return;
        }
        String currentToken = this.streamConnection.authToken();
        if (!Objects.equals(this.token, currentToken)) {
            this.token = currentToken;
            logger.info("Sending new token");
            this.streamConnection.sendNext((Object)YdbTopic.StreamReadMessage.FromClient.newBuilder().setUpdateTokenRequest(YdbTopic.UpdateTokenRequest.newBuilder().setToken(this.token).build()).build());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Sending request:\n{}", (Object)request);
        } else {
            logger.debug("Sending request");
        }
        this.streamConnection.sendNext((Object)request);
    }

    public boolean stop() {
        logger.info("ReadSession stop");
        return this.isWorking.compareAndSet(true, false);
    }

    public synchronized void shutdown() {
        logger.info("ReadSession shutdown");
        if (!this.stop()) {
            return;
        }
        this.streamConnection.close();
    }
}

