/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import tech.ydb.topic.description.Codec;
import tech.ydb.topic.read.impl.BatchMeta;
import tech.ydb.topic.read.impl.MessageImpl;

public class Batch {
    private final BatchMeta meta;
    private final List<MessageImpl> messages = new ArrayList<MessageImpl>();
    private final CompletableFuture<Void> readFuture = new CompletableFuture();
    private boolean decompressed = false;

    public Batch(BatchMeta meta) {
        this.meta = meta;
    }

    public List<MessageImpl> getMessages() {
        return this.messages;
    }

    public void addMessage(MessageImpl message) {
        this.messages.add(message);
    }

    public void complete() {
        this.readFuture.complete(null);
    }

    public CompletableFuture<Void> getReadFuture() {
        return this.readFuture;
    }

    public Codec getCodec() {
        return this.meta.getCodec();
    }

    public boolean isDecompressed() {
        return this.decompressed;
    }

    public void setDecompressed(boolean decompressed) {
        this.decompressed = decompressed;
    }
}

