/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.settings;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import tech.ydb.topic.settings.TopicReadSettings;

public class ReaderSettings {
    private static final long MAX_MEMORY_USAGE_BYTES_DEFAULT = 0x6400000L;
    private final String consumerName;
    private final String readerName;
    private final List<TopicReadSettings> topics;
    private final long maxMemoryUsageBytes;
    private final Duration maxLag;
    private final Instant readFrom;
    private final boolean decompress;
    private final Executor decompressionExecutor;

    private ReaderSettings(Builder builder) {
        this.consumerName = builder.consumerName;
        this.readerName = builder.readerName;
        this.topics = ImmutableList.copyOf((Collection)builder.topics);
        this.maxMemoryUsageBytes = builder.maxMemoryUsageBytes;
        this.maxLag = builder.maxLag;
        this.readFrom = builder.readFrom;
        this.decompress = builder.decompress;
        this.decompressionExecutor = builder.decompressionExecutor;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    @Nullable
    public String getReaderName() {
        return this.readerName;
    }

    public List<TopicReadSettings> getTopics() {
        return this.topics;
    }

    public long getMaxMemoryUsageBytes() {
        return this.maxMemoryUsageBytes;
    }

    public Duration getMaxLag() {
        return this.maxLag;
    }

    public Instant getReadFrom() {
        return this.readFrom;
    }

    public boolean isDecompress() {
        return this.decompress;
    }

    public Executor getDecompressionExecutor() {
        return this.decompressionExecutor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String consumerName = null;
        private boolean readWithoutConsumer = false;
        private String readerName = null;
        private List<TopicReadSettings> topics = new ArrayList<TopicReadSettings>();
        private long maxMemoryUsageBytes = 0x6400000L;
        private Duration maxLag = null;
        private Instant readFrom = null;
        private boolean decompress = true;
        private Executor decompressionExecutor = null;

        public Builder setConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public Builder withoutConsumer() {
            this.readWithoutConsumer = true;
            return this;
        }

        public Builder setReaderName(String readerName) {
            this.readerName = readerName;
            return this;
        }

        public Builder addTopic(TopicReadSettings topic) {
            this.topics.add(topic);
            return this;
        }

        public Builder setTopics(List<TopicReadSettings> topics) {
            this.topics = topics;
            return this;
        }

        public Builder setMaxMemoryUsageBytes(long maxMemoryUsageBytes) {
            this.maxMemoryUsageBytes = maxMemoryUsageBytes;
            return this;
        }

        public Builder setMaxLag(Duration maxLag) {
            this.maxLag = maxLag;
            return this;
        }

        public Builder setReadFrom(Instant readFrom) {
            this.readFrom = readFrom;
            return this;
        }

        public Builder setDecompress(boolean decompress) {
            this.decompress = decompress;
            return this;
        }

        public Builder setDecompressionExecutor(Executor decompressionExecutor) {
            this.decompressionExecutor = decompressionExecutor;
            return this;
        }

        public ReaderSettings build() {
            if (this.consumerName == null) {
                if (!this.readWithoutConsumer) {
                    throw new IllegalArgumentException("Missing consumer name for read settings. Use withoutConsumer option explicitly if you want to read without a consumer");
                }
            } else if (this.readWithoutConsumer) {
                throw new IllegalArgumentException("Both mutually exclusive options consumerName and withoutConsumer are set for read settings");
            }
            if (this.topics.isEmpty()) {
                throw new IllegalArgumentException("Missing topics for read settings. At least one should be set");
            }
            return new ReaderSettings(this);
        }
    }
}

