/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.read.impl;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.Map;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.description.Codec;
import tech.ydb.topic.utils.ProtoUtils;

public class BatchMeta {
    private final String producerId;
    private final Map<String, String> writeSessionMeta;
    private final Codec codec;
    private final Instant writtenAt;

    public BatchMeta(YdbTopic.StreamReadMessage.ReadResponse.Batch batch) {
        this.producerId = batch.getProducerId();
        this.writeSessionMeta = batch.getWriteSessionMetaMap();
        this.codec = ProtoUtils.codecFromProto(batch.getCodec());
        this.writtenAt = ProtobufUtils.protoToInstant((Timestamp)batch.getWrittenAt());
    }

    public String getProducerId() {
        return this.producerId;
    }

    public Map<String, String> getWriteSessionMeta() {
        return this.writeSessionMeta;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public Instant getWrittenAt() {
        return this.writtenAt;
    }
}

