/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import tech.ydb.core.Operations;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.proto.topic.v1.TopicServiceGrpc;
import tech.ydb.topic.TopicRpc;

@ParametersAreNonnullByDefault
public final class GrpcTopicRpc
implements TopicRpc {
    private final GrpcTransport transport;

    private GrpcTopicRpc(GrpcTransport transport) {
        this.transport = transport;
    }

    public static GrpcTopicRpc useTransport(@WillNotClose GrpcTransport transport) {
        return new GrpcTopicRpc(transport);
    }

    @Override
    public CompletableFuture<Status> createTopic(YdbTopic.CreateTopicRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TopicServiceGrpc.getCreateTopicMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTopic.CreateTopicResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> alterTopic(YdbTopic.AlterTopicRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TopicServiceGrpc.getAlterTopicMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTopic.AlterTopicResponse::getOperation));
    }

    @Override
    public CompletableFuture<Result<YdbTopic.DescribeTopicResult>> describeTopic(YdbTopic.DescribeTopicRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TopicServiceGrpc.getDescribeTopicMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTopic.DescribeTopicResponse::getOperation, YdbTopic.DescribeTopicResult.class));
    }

    @Override
    public CompletableFuture<Status> dropTopic(YdbTopic.DropTopicRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TopicServiceGrpc.getDropTopicMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTopic.DropTopicResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> commitOffset(YdbTopic.CommitOffsetRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TopicServiceGrpc.getCommitOffsetMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTopic.CommitOffsetResponse::getOperation));
    }

    @Override
    public GrpcReadWriteStream<YdbTopic.StreamWriteMessage.FromServer, YdbTopic.StreamWriteMessage.FromClient> writeSession() {
        return this.transport.readWriteStreamCall(TopicServiceGrpc.getStreamWriteMethod(), GrpcRequestSettings.newBuilder().build());
    }

    @Override
    public GrpcReadWriteStream<YdbTopic.StreamReadMessage.FromServer, YdbTopic.StreamReadMessage.FromClient> readSession() {
        return this.transport.readWriteStreamCall(TopicServiceGrpc.getStreamReadMethod(), GrpcRequestSettings.newBuilder().build());
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.transport.getScheduler();
    }
}

