/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.write.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.TopicRpc;

public class WriteSession {
    private static final Logger logger = LoggerFactory.getLogger(WriteSession.class);
    private final GrpcReadWriteStream<YdbTopic.StreamWriteMessage.FromServer, YdbTopic.StreamWriteMessage.FromClient> streamConnection;
    private final AtomicBoolean isWorking = new AtomicBoolean(true);
    private String token;

    public WriteSession(TopicRpc rpc) {
        this.streamConnection = rpc.writeSession();
        this.token = this.streamConnection.authToken();
    }

    public synchronized CompletableFuture<Status> start(GrpcReadStream.Observer<YdbTopic.StreamWriteMessage.FromServer> streamObserver) {
        logger.debug("WriteSession start");
        return this.streamConnection.start(message -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Message received:\n{}", message);
            } else {
                logger.debug("Message received");
            }
            if (this.isWorking.get()) {
                streamObserver.onNext(message);
            }
        });
    }

    public synchronized void send(YdbTopic.StreamWriteMessage.FromClient request) {
        if (!this.isWorking.get()) {
            if (logger.isTraceEnabled()) {
                logger.trace("WriteSession is already closed. This message is NOT sent:\n{}", (Object)request);
            } else if (logger.isDebugEnabled()) {
                logger.debug("WriteSession is already closed. A message of {} bytes was not sent", (Object)request.getSerializedSize());
            }
            return;
        }
        String currentToken = this.streamConnection.authToken();
        if (!Objects.equals(this.token, currentToken)) {
            this.token = currentToken;
            logger.info("Sending new token");
            this.streamConnection.sendNext((Object)YdbTopic.StreamWriteMessage.FromClient.newBuilder().setUpdateTokenRequest(YdbTopic.UpdateTokenRequest.newBuilder().setToken(this.token).build()).build());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Sending request:\n{}", (Object)request);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Sending request of {} bytes", (Object)request.getSerializedSize());
        }
        this.streamConnection.sendNext((Object)request);
    }

    public boolean stop() {
        logger.info("WriteSession stop");
        return this.isWorking.compareAndSet(true, false);
    }

    public synchronized void shutdown() {
        logger.info("WriteSession shutdown");
        if (!this.stop()) {
            return;
        }
        this.streamConnection.close();
    }
}

