/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.write.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import tech.ydb.topic.write.Message;
import tech.ydb.topic.write.WriteAck;

public class EnqueuedMessage {
    private final Message message;
    private final CompletableFuture<WriteAck> future = new CompletableFuture();
    private final AtomicBoolean isCompressed = new AtomicBoolean(false);
    private final long uncompressedSizeBytes;
    private long compressedSizeBytes;
    private Long seqNo;

    public EnqueuedMessage(Message message) {
        this.message = message;
        this.uncompressedSizeBytes = message.getData().length;
    }

    public Message getMessage() {
        return this.message;
    }

    public CompletableFuture<WriteAck> getFuture() {
        return this.future;
    }

    public boolean isCompressed() {
        return this.isCompressed.get();
    }

    public void setCompressed(boolean compressed) {
        this.isCompressed.set(compressed);
    }

    public long getUncompressedSizeBytes() {
        return this.uncompressedSizeBytes;
    }

    public long getCompressedSizeBytes() {
        return this.compressedSizeBytes;
    }

    public void setCompressedSizeBytes(long compressedSizeBytes) {
        this.compressedSizeBytes = compressedSizeBytes;
    }

    public long getSizeBytes() {
        return this.isCompressed() ? this.getCompressedSizeBytes() : this.getUncompressedSizeBytes();
    }

    public Long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }
}

