/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic.impl;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Operations;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.core.utils.ProtobufUtils;
import tech.ydb.proto.topic.YdbTopic;
import tech.ydb.topic.TopicClient;
import tech.ydb.topic.TopicRpc;
import tech.ydb.topic.description.Codec;
import tech.ydb.topic.description.Consumer;
import tech.ydb.topic.description.MeteringMode;
import tech.ydb.topic.description.PartitionInfo;
import tech.ydb.topic.description.SupportedCodecs;
import tech.ydb.topic.description.TopicDescription;
import tech.ydb.topic.impl.TopicClientBuilderImpl;
import tech.ydb.topic.read.AsyncReader;
import tech.ydb.topic.read.SyncReader;
import tech.ydb.topic.read.impl.AsyncReaderImpl;
import tech.ydb.topic.read.impl.SyncReaderImpl;
import tech.ydb.topic.settings.AlterConsumerSettings;
import tech.ydb.topic.settings.AlterPartitioningSettings;
import tech.ydb.topic.settings.AlterTopicSettings;
import tech.ydb.topic.settings.CreateTopicSettings;
import tech.ydb.topic.settings.DescribeTopicSettings;
import tech.ydb.topic.settings.DropTopicSettings;
import tech.ydb.topic.settings.PartitioningSettings;
import tech.ydb.topic.settings.ReadEventHandlersSettings;
import tech.ydb.topic.settings.ReaderSettings;
import tech.ydb.topic.settings.WriterSettings;
import tech.ydb.topic.utils.ProtoUtils;
import tech.ydb.topic.write.AsyncWriter;
import tech.ydb.topic.write.SyncWriter;
import tech.ydb.topic.write.impl.AsyncWriterImpl;
import tech.ydb.topic.write.impl.SyncWriterImpl;

public class TopicClientImpl
implements TopicClient {
    private static final Logger logger = LoggerFactory.getLogger(TopicClientImpl.class);
    private static final int DEFAULT_COMPRESSION_THREAD_COUNT = 5;
    private final TopicRpc topicRpc;
    private final Executor compressionExecutor;
    private final ExecutorService defaultCompressionExecutorService;

    TopicClientImpl(TopicClientBuilderImpl builder) {
        this.topicRpc = builder.topicRpc;
        if (builder.compressionExecutor != null) {
            this.defaultCompressionExecutorService = null;
            this.compressionExecutor = builder.compressionExecutor;
        } else {
            this.defaultCompressionExecutorService = Executors.newFixedThreadPool(builder.compressionExecutorThreadCount == null ? 5 : builder.compressionExecutorThreadCount);
            this.compressionExecutor = this.defaultCompressionExecutorService;
        }
    }

    public static TopicClient.Builder newClient(TopicRpc rpc) {
        return new TopicClientBuilderImpl(rpc);
    }

    private GrpcRequestSettings makeGrpcRequestSettings(BaseRequestSettings settings) {
        return GrpcRequestSettings.newBuilder().withDeadline(settings.getRequestTimeout()).build();
    }

    @Override
    public CompletableFuture<Status> createTopic(String path, CreateTopicSettings settings) {
        SupportedCodecs supportedCodecs;
        java.time.Duration retentionPeriod;
        YdbTopic.CreateTopicRequest.Builder requestBuilder = YdbTopic.CreateTopicRequest.newBuilder().setOperationParams(Operations.createParams((OperationSettings)settings)).setPath(path).setRetentionStorageMb(settings.getRetentionStorageMb()).setPartitionWriteSpeedBytesPerSecond(settings.getPartitionWriteSpeedBytesPerSecond()).setPartitionWriteBurstBytes(settings.getPartitionWriteBurstBytes()).putAllAttributes(settings.getAttributes()).setMeteringMode(TopicClientImpl.toProto(settings.getMeteringMode()));
        PartitioningSettings partitioningSettings = settings.getPartitioningSettings();
        if (partitioningSettings != null) {
            requestBuilder.setPartitioningSettings(YdbTopic.PartitioningSettings.newBuilder().setMinActivePartitions(partitioningSettings.getMinActivePartitions()).setPartitionCountLimit(partitioningSettings.getPartitionCountLimit()));
        }
        if ((retentionPeriod = settings.getRetentionPeriod()) != null) {
            requestBuilder.setRetentionPeriod(ProtobufUtils.durationToProto((java.time.Duration)retentionPeriod));
        }
        if ((supportedCodecs = settings.getSupportedCodecs()) != null) {
            requestBuilder.setSupportedCodecs(TopicClientImpl.toProto(supportedCodecs));
        }
        for (Consumer consumer : settings.getConsumers()) {
            requestBuilder.addConsumers(TopicClientImpl.toProto(consumer));
        }
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.topicRpc.createTopic(requestBuilder.build(), grpcRequestSettings);
    }

    @Override
    public CompletableFuture<Status> alterTopic(String path, AlterTopicSettings settings) {
        MeteringMode meteringMode;
        Long partitionWriteBurstBytes;
        Long partitionWriteSpeedBytesPerSecond;
        SupportedCodecs supportedCodecs;
        Long retentionStorageMb;
        java.time.Duration retentionPeriod;
        YdbTopic.AlterTopicRequest.Builder requestBuilder = YdbTopic.AlterTopicRequest.newBuilder().setOperationParams(Operations.createParams((OperationSettings)settings)).setPath(path);
        AlterPartitioningSettings partitioningSettings = settings.getAlterPartitioningSettings();
        if (partitioningSettings != null) {
            Long partitionCountLimit;
            YdbTopic.AlterPartitioningSettings.Builder builder = YdbTopic.AlterPartitioningSettings.newBuilder();
            Long minActivePartitions = partitioningSettings.getMinActivePartitions();
            if (minActivePartitions != null) {
                builder.setSetMinActivePartitions(minActivePartitions.longValue());
            }
            if ((partitionCountLimit = partitioningSettings.getPartitionCountLimit()) != null) {
                builder.setSetPartitionCountLimit(partitionCountLimit.longValue());
            }
            requestBuilder.setAlterPartitioningSettings(builder);
        }
        if ((retentionPeriod = settings.getRetentionPeriod()) != null) {
            requestBuilder.setSetRetentionPeriod(ProtobufUtils.durationToProto((java.time.Duration)retentionPeriod));
        }
        if ((retentionStorageMb = settings.getRetentionStorageMb()) != null) {
            requestBuilder.setSetRetentionStorageMb(retentionStorageMb.longValue());
        }
        if ((supportedCodecs = settings.getSupportedCodecs()) != null) {
            requestBuilder.setSetSupportedCodecs(TopicClientImpl.toProto(supportedCodecs));
        }
        if ((partitionWriteSpeedBytesPerSecond = settings.getPartitionWriteSpeedBytesPerSecond()) != null) {
            requestBuilder.setSetPartitionWriteSpeedBytesPerSecond(partitionWriteSpeedBytesPerSecond.longValue());
        }
        if ((partitionWriteBurstBytes = settings.getPartitionWriteBurstBytes()) != null) {
            requestBuilder.setSetPartitionWriteBurstBytes(partitionWriteBurstBytes.longValue());
        }
        for (Consumer consumer : settings.getAddConsumers()) {
            requestBuilder.addAddConsumers(TopicClientImpl.toProto(consumer));
        }
        for (String string : settings.getDropConsumers()) {
            requestBuilder.addDropConsumers(string);
        }
        List<AlterConsumerSettings> alterConsumers = settings.getAlterConsumers();
        if (!alterConsumers.isEmpty()) {
            for (AlterConsumerSettings alterConsumer : alterConsumers) {
                Map<String, String> consumerAttributes;
                SupportedCodecs consumerSupportedCodecs;
                Instant readFrom;
                YdbTopic.AlterConsumer.Builder alterConsumerBuilder = YdbTopic.AlterConsumer.newBuilder().setName(alterConsumer.getName());
                Boolean important = alterConsumer.getImportant();
                if (important != null) {
                    alterConsumerBuilder.setSetImportant(important.booleanValue());
                }
                if ((readFrom = alterConsumer.getReadFrom()) != null) {
                    alterConsumerBuilder.setSetReadFrom(ProtobufUtils.instantToProto((Instant)readFrom));
                }
                if ((consumerSupportedCodecs = alterConsumer.getSupportedCodecs()) != null) {
                    alterConsumerBuilder.setSetSupportedCodecs(TopicClientImpl.toProto(consumerSupportedCodecs));
                }
                if (!(consumerAttributes = alterConsumer.getAlterAttributes()).isEmpty()) {
                    alterConsumerBuilder.putAllAlterAttributes(consumerAttributes);
                }
                for (String attributeToDrop : alterConsumer.getDropAttributes()) {
                    alterConsumerBuilder.putAlterAttributes(attributeToDrop, "");
                }
                requestBuilder.addAlterConsumers(alterConsumerBuilder);
            }
        }
        if ((meteringMode = settings.getMeteringMode()) != null) {
            requestBuilder.setSetMeteringMode(TopicClientImpl.toProto(meteringMode));
        }
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.topicRpc.alterTopic(requestBuilder.build(), grpcRequestSettings);
    }

    @Override
    public CompletableFuture<Status> dropTopic(String path, DropTopicSettings settings) {
        YdbTopic.DropTopicRequest request = YdbTopic.DropTopicRequest.newBuilder().setOperationParams(Operations.createParams((OperationSettings)settings)).setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.topicRpc.dropTopic(request, grpcRequestSettings);
    }

    @Override
    public CompletableFuture<Result<TopicDescription>> describeTopic(String path, DescribeTopicSettings settings) {
        YdbTopic.DescribeTopicRequest request = YdbTopic.DescribeTopicRequest.newBuilder().setOperationParams(Operations.createParams((OperationSettings)settings)).setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.topicRpc.describeTopic(request, grpcRequestSettings).thenApply(result -> result.map(this::mapDescribeTopic));
    }

    private TopicDescription mapDescribeTopic(YdbTopic.DescribeTopicResult result) {
        Object partition2;
        if (logger.isTraceEnabled()) {
            logger.trace("Received topic describe response:\n{}", (Object)result);
        }
        TopicDescription.Builder description = TopicDescription.newBuilder().setRetentionPeriod(ProtobufUtils.protoToDuration((Duration)result.getRetentionPeriod())).setRetentionStorageMb(result.getRetentionStorageMb()).setPartitionWriteSpeedBytesPerSecond(result.getPartitionWriteSpeedBytesPerSecond()).setPartitionWriteBurstBytes(result.getPartitionWriteBurstBytes()).setAttributes(result.getAttributesMap()).setMeteringMode(TopicClientImpl.fromProto(result.getMeteringMode()));
        YdbTopic.PartitioningSettings partitioningSettings = result.getPartitioningSettings();
        description.setPartitioningSettings(PartitioningSettings.newBuilder().setMinActivePartitions(partitioningSettings.getMinActivePartitions()).setPartitionCountLimit(partitioningSettings.getPartitionCountLimit()).build());
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (Object partition2 : result.getPartitionsList()) {
            PartitionInfo.Builder partitionBuilder = PartitionInfo.newBuilder().setPartitionId(partition2.getPartitionId()).setActive(partition2.getActive()).setChildPartitionIds(partition2.getChildPartitionIdsList()).setParentPartitionIds(partition2.getParentPartitionIdsList());
            partitions.add(partitionBuilder.build());
        }
        description.setPartitions(partitions);
        SupportedCodecs.Builder supportedCodecsBuilder = SupportedCodecs.newBuilder();
        partition2 = result.getSupportedCodecs().getCodecsList().iterator();
        while (partition2.hasNext()) {
            int codec = (Integer)partition2.next();
            supportedCodecsBuilder.addCodec(TopicClientImpl.codecFromProto(codec));
        }
        description.setSupportedCodecs(supportedCodecsBuilder.build());
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (YdbTopic.Consumer consumer : result.getConsumersList()) {
            Consumer.Builder consumerBuilder = Consumer.newBuilder().setName(consumer.getName()).setImportant(consumer.getImportant()).setReadFrom(ProtobufUtils.protoToInstant((Timestamp)consumer.getReadFrom())).setAttributes(consumer.getAttributesMap());
            SupportedCodecs.Builder consumerSupportedCodecsBuilder = SupportedCodecs.newBuilder();
            Iterator iterator = consumer.getSupportedCodecs().getCodecsList().iterator();
            while (iterator.hasNext()) {
                int codec = (Integer)iterator.next();
                consumerSupportedCodecsBuilder.addCodec(TopicClientImpl.codecFromProto(codec));
            }
            consumerBuilder.setSupportedCodecs(consumerSupportedCodecsBuilder.build());
            consumers.add(consumerBuilder.build());
        }
        description.setConsumers(consumers);
        return description.build();
    }

    @Override
    public SyncReader createSyncReader(ReaderSettings settings) {
        return new SyncReaderImpl(this.topicRpc, settings);
    }

    @Override
    public AsyncReader createAsyncReader(ReaderSettings settings, ReadEventHandlersSettings handlersSettings) {
        return new AsyncReaderImpl(this.topicRpc, settings, handlersSettings);
    }

    @Override
    public SyncWriter createSyncWriter(WriterSettings settings) {
        return new SyncWriterImpl(this.topicRpc, settings, this.compressionExecutor);
    }

    @Override
    public AsyncWriter createAsyncWriter(WriterSettings settings) {
        return new AsyncWriterImpl(this.topicRpc, settings, this.compressionExecutor);
    }

    private static Codec codecFromProto(int codec) {
        switch (codec) {
            case 1: {
                return Codec.RAW;
            }
            case 2: {
                return Codec.GZIP;
            }
            case 3: {
                return Codec.LZOP;
            }
            case 4: {
                return Codec.ZSTD;
            }
            case 10000: {
                return Codec.CUSTOM;
            }
        }
        throw new RuntimeException("Unknown codec value from proto: " + codec);
    }

    private static YdbTopic.MeteringMode toProto(MeteringMode meteringMode) {
        switch (meteringMode) {
            case UNSPECIFIED: {
                return YdbTopic.MeteringMode.METERING_MODE_UNSPECIFIED;
            }
            case REQUEST_UNITS: {
                return YdbTopic.MeteringMode.METERING_MODE_REQUEST_UNITS;
            }
            case RESERVED_CAPACITY: {
                return YdbTopic.MeteringMode.METERING_MODE_RESERVED_CAPACITY;
            }
        }
        throw new IllegalArgumentException("Unknown metering mode: " + (Object)((Object)meteringMode));
    }

    private static MeteringMode fromProto(YdbTopic.MeteringMode meteringMode) {
        switch (meteringMode) {
            case METERING_MODE_UNSPECIFIED: {
                return MeteringMode.UNSPECIFIED;
            }
            case METERING_MODE_REQUEST_UNITS: {
                return MeteringMode.REQUEST_UNITS;
            }
            case METERING_MODE_RESERVED_CAPACITY: {
                return MeteringMode.RESERVED_CAPACITY;
            }
        }
        throw new RuntimeException("Unknown metering mode from proto: " + meteringMode);
    }

    private static YdbTopic.Consumer toProto(Consumer consumer) {
        Instant readFrom;
        SupportedCodecs consumerCodecs;
        YdbTopic.Consumer.Builder consumerBuilder = YdbTopic.Consumer.newBuilder().setName(consumer.getName()).putAllAttributes(consumer.getAttributes());
        Boolean important = consumer.isImportant();
        if (important != null) {
            consumerBuilder.setImportant(important.booleanValue());
        }
        if ((consumerCodecs = consumer.getSupportedCodecs()) != null) {
            consumerBuilder.setSupportedCodecs(TopicClientImpl.toProto(consumerCodecs));
        }
        if ((readFrom = consumer.getReadFrom()) != null) {
            consumerBuilder.setReadFrom(ProtobufUtils.instantToProto((Instant)readFrom));
        }
        return consumerBuilder.build();
    }

    private static YdbTopic.SupportedCodecs toProto(SupportedCodecs supportedCodecs) {
        List<Codec> supportedCodecsList = supportedCodecs.getCodecs();
        YdbTopic.SupportedCodecs.Builder codecsBuilder = YdbTopic.SupportedCodecs.newBuilder();
        for (Codec codec : supportedCodecsList) {
            codecsBuilder.addCodecs(ProtoUtils.toProto(codec));
        }
        return codecsBuilder.build();
    }

    @Override
    public void close() {
        logger.debug("TopicClientImpl.close() is called");
        if (this.defaultCompressionExecutorService != null) {
            this.defaultCompressionExecutorService.shutdown();
        }
    }
}

