/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.topic;

import io.grpc.ExperimentalApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.WillNotClose;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.topic.description.TopicDescription;
import tech.ydb.topic.impl.GrpcTopicRpc;
import tech.ydb.topic.impl.TopicClientImpl;
import tech.ydb.topic.read.AsyncReader;
import tech.ydb.topic.read.SyncReader;
import tech.ydb.topic.settings.AlterTopicSettings;
import tech.ydb.topic.settings.CreateTopicSettings;
import tech.ydb.topic.settings.DescribeTopicSettings;
import tech.ydb.topic.settings.DropTopicSettings;
import tech.ydb.topic.settings.ReadEventHandlersSettings;
import tech.ydb.topic.settings.ReaderSettings;
import tech.ydb.topic.settings.WriterSettings;
import tech.ydb.topic.write.AsyncWriter;
import tech.ydb.topic.write.SyncWriter;

@ExperimentalApi(value="Topic service interfaces are experimental and may change without notice")
public interface TopicClient
extends AutoCloseable {
    public static Builder newClient(@WillNotClose GrpcTransport transport) {
        return TopicClientImpl.newClient(GrpcTopicRpc.useTransport(transport));
    }

    public CompletableFuture<Status> createTopic(String var1, CreateTopicSettings var2);

    public CompletableFuture<Status> alterTopic(String var1, AlterTopicSettings var2);

    public CompletableFuture<Status> dropTopic(String var1, DropTopicSettings var2);

    default public CompletableFuture<Status> dropTopic(String path) {
        return this.dropTopic(path, DropTopicSettings.newBuilder().build());
    }

    public CompletableFuture<Result<TopicDescription>> describeTopic(String var1, DescribeTopicSettings var2);

    default public CompletableFuture<Result<TopicDescription>> describeTopic(String path) {
        return this.describeTopic(path, DescribeTopicSettings.newBuilder().build());
    }

    public SyncReader createSyncReader(ReaderSettings var1);

    public AsyncReader createAsyncReader(ReaderSettings var1, ReadEventHandlersSettings var2);

    public SyncWriter createSyncWriter(WriterSettings var1);

    public AsyncWriter createAsyncWriter(WriterSettings var1);

    @Override
    public void close();

    public static interface Builder {
        public TopicClient build();

        public Builder setCompressionExecutor(Executor var1);

        public Builder setCompressionPoolThreadCount(Integer var1);
    }
}

