/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.DecimalType;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoValue;

public class DecimalValue
implements Value<DecimalType> {
    private static final DecimalType MAX_DECIMAL = DecimalType.of(35);
    private static final long HALF_LONG_MASK = 0xFFFFFFFFL;
    private static final long LONG_SIGN_BIT = Long.MIN_VALUE;
    private static final long LONG_MAX_DIGITS = 18L;
    private static final BigInteger BIGINT_TWO = BigInteger.valueOf(2L);
    public static final DecimalValue INF = new DecimalValue(MAX_DECIMAL, 5421010862427522L, 3136633892082024448L);
    public static final DecimalValue NEG_INF = new DecimalValue(MAX_DECIMAL, -5421010862427523L, -3136633892082024448L);
    public static final DecimalValue NAN = new DecimalValue(MAX_DECIMAL, 5421010862427522L, 3136633892082024449L);
    private final DecimalType type;
    private final long high;
    private final long low;

    DecimalValue(DecimalType type, long high, long low) {
        this.type = type;
        this.high = high;
        this.low = low;
    }

    @Override
    public DecimalType getType() {
        return this.type;
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public boolean isInf() {
        return this.high == DecimalValue.INF.high && this.low == DecimalValue.INF.low;
    }

    public boolean isNegativeInf() {
        return this.high == DecimalValue.NEG_INF.high && this.low == DecimalValue.NEG_INF.low;
    }

    public boolean isNan() {
        return this.high == DecimalValue.NAN.high && this.low == DecimalValue.NAN.low;
    }

    public boolean isZero() {
        return this.high == 0L && this.low == 0L;
    }

    public boolean isNegative() {
        return (this.high & Long.MIN_VALUE) != 0L;
    }

    public BigInteger toUnscaledBigInteger() {
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        if (this.high == 0L && this.low > 0L) {
            return BigInteger.valueOf(this.low);
        }
        byte[] buf = new byte[16];
        DecimalValue.putLongBe(buf, 0, this.high);
        DecimalValue.putLongBe(buf, 8, this.low);
        return new BigInteger(buf);
    }

    public BigInteger toBigInteger() {
        if (this.isZero()) {
            return BigInteger.ZERO;
        }
        BigInteger unscaled = this.toUnscaledBigInteger();
        if (this.type.getScale() == 0) {
            return unscaled;
        }
        BigInteger scale = BigInteger.TEN.pow(this.type.getScale());
        BigInteger halfEven = scale.divide(BIGINT_TWO);
        BigInteger[] scaled = unscaled.divideAndRemainder(BigInteger.TEN.pow(this.type.getScale()));
        if (unscaled.signum() > 0 && scaled[1].compareTo(halfEven) >= 0) {
            return scaled[0].add(BigInteger.ONE);
        }
        if (unscaled.signum() < 0 && scaled[1].negate().compareTo(halfEven) >= 0) {
            return scaled[0].add(BigInteger.ONE.negate());
        }
        return scaled[0];
    }

    public BigDecimal toBigDecimal() {
        if (this.isZero()) {
            return BigDecimal.ZERO.setScale(this.type.getScale());
        }
        return new BigDecimal(this.toUnscaledBigInteger(), this.type.getScale());
    }

    public long toLong() {
        return this.toBigInteger().longValueExact();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalValue that = (DecimalValue)o;
        return this.high == that.high && this.low == that.low && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (int)(this.high ^ this.high >>> 32);
        result = 31 * result + (int)(this.low ^ this.low >>> 32);
        return result;
    }

    public String toString() {
        if (this.isInf()) {
            return "inf";
        }
        if (this.isNegativeInf()) {
            return "-inf";
        }
        if (this.isNan()) {
            return "nan";
        }
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder(39);
        DecimalValue.writeAsString(sb, this.type.getScale(), this.high, this.low);
        return sb.toString();
    }

    public String toUnscaledString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder(37);
        DecimalValue.writeAsString(sb, 0, this.high, this.low);
        return sb.toString();
    }

    private static void writeAsString(StringBuilder sb, int scale, long ahigh, long alow) {
        long high = ahigh;
        long low = alow;
        boolean isNegative = (ahigh & Long.MIN_VALUE) != 0L;
        boolean dot = false;
        if ((high & Long.MIN_VALUE) != 0L && (high != Long.MIN_VALUE || low != 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        long lowHi = low >>> 32;
        long lowLo = low & 0xFFFFFFFFL;
        int divisor = 10;
        do {
            long remainder = high % 10L;
            high /= 10L;
            remainder = lowHi + (remainder << 32);
            lowHi = remainder / 10L;
            remainder %= 10L;
            remainder = lowLo + (remainder << 32);
            lowLo = remainder / 10L;
            sb.append(Character.forDigit((int)(remainder % 10L), 10));
            if (--scale != 0) continue;
            sb.append('.');
            dot = true;
        } while (high != 0L || lowHi != 0L || lowLo != 0L);
        if (dot && scale == 0) {
            sb.append('0');
        } else if (!dot && scale > 0) {
            while (scale-- > 0) {
                sb.append('0');
            }
            sb.append('.');
            sb.append('0');
        }
        if (isNegative) {
            sb.append('-');
        }
        sb.reverse();
    }

    @Override
    public ValueProtos.Value toPb() {
        return ProtoValue.fromDecimal(this.high, this.low);
    }

    private static void putLongBe(byte[] buf, int index, long value) {
        buf[index] = (byte)(value >>> 56 & 0xFFL);
        buf[index + 1] = (byte)(value >>> 48 & 0xFFL);
        buf[index + 2] = (byte)(value >>> 40 & 0xFFL);
        buf[index + 3] = (byte)(value >>> 32 & 0xFFL);
        buf[index + 4] = (byte)(value >>> 24 & 0xFFL);
        buf[index + 5] = (byte)(value >>> 16 & 0xFFL);
        buf[index + 6] = (byte)(value >>> 8 & 0xFFL);
        buf[index + 7] = (byte)(value & 0xFFL);
    }

    private static long getLongBe(byte[] buf, int from, int to) {
        long r = 0L;
        for (int i = from; i < to; ++i) {
            r = r << 8 | (long)(buf[i] & 0xFF);
        }
        return r;
    }

    private static boolean isNan(long high, long low) {
        return DecimalValue.NAN.high == high && DecimalValue.NAN.low == low;
    }

    private static boolean isInf(long high, long low) {
        return high > DecimalValue.INF.high || high == DecimalValue.INF.high && Long.compareUnsigned(low, DecimalValue.INF.low) >= 0;
    }

    private static boolean isNegInf(long high, long low) {
        return high < DecimalValue.NEG_INF.high || high == DecimalValue.NEG_INF.high && Long.compareUnsigned(low, DecimalValue.NEG_INF.low) <= 0;
    }

    private static DecimalValue newNan(DecimalType type) {
        return new DecimalValue(type, DecimalValue.NAN.high, DecimalValue.NAN.low);
    }

    private static DecimalValue newInf(DecimalType type) {
        return new DecimalValue(type, DecimalValue.INF.high, DecimalValue.INF.low);
    }

    private static DecimalValue newNegInf(DecimalType type) {
        return new DecimalValue(type, DecimalValue.NEG_INF.high, DecimalValue.NEG_INF.low);
    }

    static DecimalValue fromUnscaledLong(DecimalType type, long value) {
        if (value == 0L) {
            return new DecimalValue(type, 0L, 0L);
        }
        long high = value > 0L ? 0L : -1L;
        return new DecimalValue(type, high, value);
    }

    static DecimalValue fromBits(DecimalType type, long high, long low) {
        if (high == 0L && low == 0L) {
            return new DecimalValue(type, 0L, 0L);
        }
        if (DecimalValue.isNan(high, low)) {
            return DecimalValue.newNan(type);
        }
        if (DecimalValue.isInf(high, low)) {
            return DecimalValue.newInf(type);
        }
        if (DecimalValue.isNegInf(high, low)) {
            return DecimalValue.newNegInf(type);
        }
        return new DecimalValue(type, high, low);
    }

    static DecimalValue fromUnscaledBigInteger(DecimalType type, BigInteger value) {
        boolean negative;
        int bitLength = value.bitLength();
        if (bitLength < 64) {
            return DecimalValue.fromUnscaledLong(type, value.longValue());
        }
        boolean bl = negative = value.signum() < 0;
        if (bitLength > 128) {
            return negative ? DecimalValue.newNegInf(type) : DecimalValue.newInf(type);
        }
        byte[] buf = value.abs().toByteArray();
        long high = DecimalValue.getLongBe(buf, 0, buf.length - 8);
        long low = DecimalValue.getLongBe(buf, buf.length - 8, buf.length);
        if (negative && (high != Long.MIN_VALUE || low != 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        return DecimalValue.fromBits(type, high, low);
    }

    private static DecimalValue fromUnsignedLong(DecimalType type, boolean positive, long value) {
        if (value == 0L) {
            return new DecimalValue(type, 0L, 0L);
        }
        long high = 0L;
        long lowHi = value >>> 32;
        long lowLo = value & 0xFFFFFFFFL;
        for (int scale = 0; scale < type.getScale(); ++scale) {
            lowHi = lowHi * 10L + ((lowLo *= 10L) >>> 32);
            high = high * 10L + (lowHi >>> 32);
            lowLo &= 0xFFFFFFFFL;
            lowHi &= 0xFFFFFFFFL;
            if ((high & Long.MIN_VALUE) == 0L) continue;
            return positive ? DecimalValue.newInf(type) : DecimalValue.newNegInf(type);
        }
        long low = lowHi << 32 | lowLo;
        if (!(positive || high == Long.MIN_VALUE && low == 0L)) {
            high ^= 0xFFFFFFFFFFFFFFFFL;
            low ^= 0xFFFFFFFFFFFFFFFFL;
            if (++low == 0L) {
                ++high;
            }
        }
        return DecimalValue.fromBits(type, high, low);
    }

    static DecimalValue fromUnsignedLong(DecimalType type, long value) {
        return DecimalValue.fromUnsignedLong(type, true, value);
    }

    static DecimalValue fromLong(DecimalType type, long value) {
        boolean positive = value > 0L;
        return DecimalValue.fromUnsignedLong(type, positive, positive ? value : -value);
    }

    static DecimalValue fromString(DecimalType type, String value) {
        int scaleAdjust;
        if (value.isEmpty()) {
            throw new NumberFormatException("cannot parse decimal from empty string");
        }
        int end = value.length();
        int cursor = 0;
        boolean negative = false;
        if (value.charAt(cursor) == '+') {
            ++cursor;
        } else if (value.charAt(cursor) == '-') {
            ++cursor;
            negative = true;
        }
        if (end - cursor == 3) {
            char c1 = value.charAt(cursor);
            char c2 = value.charAt(cursor + 1);
            char c3 = value.charAt(cursor + 2);
            if ((c1 == 'i' || c1 == 'I') && (c2 == 'n' || c2 == 'N') || c3 == 'f' || c3 == 'F') {
                return negative ? DecimalValue.newNegInf(type) : DecimalValue.newInf(type);
            }
            if ((c1 == 'n' || c1 == 'N') && (c2 == 'a' || c2 == 'A') || c3 == 'n' || c3 == 'N') {
                return new DecimalValue(type, DecimalValue.NAN.high, DecimalValue.NAN.low);
            }
        }
        while (cursor < end && value.charAt(cursor) == '0') {
            ++cursor;
        }
        if (cursor == end) {
            return new DecimalValue(type, 0L, 0L);
        }
        long accumulated = 0L;
        int accumulatedCount = 0;
        boolean fractional = false;
        int fractionalDigits = 0;
        BigInteger unscaledValue = BigInteger.ZERO;
        while (cursor < end) {
            char ch = value.charAt(cursor);
            if (ch >= '0' && ch <= '9') {
                if ((long)accumulatedCount == 18L) {
                    if (unscaledValue == BigInteger.ZERO) {
                        unscaledValue = BigInteger.valueOf(accumulated);
                    } else {
                        unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                        unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
                    }
                    accumulated = 0L;
                    accumulatedCount = 0;
                }
                int digit = ch - 48;
                accumulated = accumulated * 10L + (long)digit;
                ++accumulatedCount;
                if (fractional) {
                    ++fractionalDigits;
                }
            } else if (ch == '.') {
                if (fractional) {
                    throw new NumberFormatException("invalid string: " + value);
                }
                fractional = true;
            } else {
                throw new NumberFormatException("invalid string: " + value);
            }
            ++cursor;
        }
        if (accumulatedCount > 0) {
            if (unscaledValue == BigInteger.ZERO) {
                unscaledValue = BigInteger.valueOf(accumulated);
            } else {
                unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(accumulatedCount));
                unscaledValue = unscaledValue.add(BigInteger.valueOf(accumulated));
            }
        }
        if ((scaleAdjust = type.getScale() - fractionalDigits) > 0) {
            unscaledValue = unscaledValue.multiply(BigInteger.TEN.pow(scaleAdjust));
        } else if (scaleAdjust < 0) {
            unscaledValue = unscaledValue.divide(BigInteger.TEN.pow(-scaleAdjust));
        }
        if (negative) {
            unscaledValue = unscaledValue.negate();
        }
        return DecimalValue.fromUnscaledBigInteger(type, unscaledValue);
    }

    static DecimalValue fromBigInteger(DecimalType type, BigInteger value) {
        BigInteger rawValue = value;
        int scale = type.getScale();
        if (scale > 0) {
            rawValue = rawValue.multiply(BigInteger.TEN.pow(scale));
        }
        return DecimalValue.fromUnscaledBigInteger(type, rawValue);
    }

    static DecimalValue fromBigDecimal(DecimalType type, BigDecimal value) {
        BigInteger rawValue = value.unscaledValue();
        int scaleAdjust = type.getScale() - value.scale();
        if (scaleAdjust > 0) {
            rawValue = rawValue.multiply(BigInteger.TEN.pow(scaleAdjust));
        } else if (scaleAdjust < 0) {
            rawValue = rawValue.divide(BigInteger.TEN.pow(-scaleAdjust));
        }
        return DecimalValue.fromUnscaledBigInteger(type, rawValue);
    }
}

