/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.description;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TableTtl {
    private static final TableTtl NOT_SET = new TableTtl(TtlMode.NOT_SET, TtlUnit.UNSPECIFIED, "", 0, null);
    @Nonnull
    private final TtlMode ttlMode;
    @Nonnull
    private final TtlUnit ttlUnit;
    @Nonnull
    private final String dateTimeColumn;
    @Nonnull
    private final Integer expireAfterSeconds;
    @Nonnull
    private final Integer runIntervalSeconds;

    @Deprecated
    public TableTtl(@Nonnull TtlMode ttlMode, @Nonnull String dateTimeColumn, @Nonnull Integer expireAfterSeconds) {
        this.ttlMode = ttlMode;
        this.dateTimeColumn = dateTimeColumn;
        this.expireAfterSeconds = expireAfterSeconds;
        this.ttlUnit = TtlUnit.UNSPECIFIED;
        this.runIntervalSeconds = null;
    }

    @Deprecated
    public TableTtl() {
        this.ttlMode = TtlMode.NOT_SET;
        this.dateTimeColumn = "";
        this.expireAfterSeconds = 0;
        this.ttlUnit = TtlUnit.UNSPECIFIED;
        this.runIntervalSeconds = null;
    }

    private TableTtl(@Nonnull TtlMode mode, @Nonnull TtlUnit unit, @Nonnull String columnName, int expireAfterSeconds, Integer runIntervalSeconds) {
        this.ttlMode = mode;
        this.dateTimeColumn = columnName;
        this.expireAfterSeconds = expireAfterSeconds;
        this.ttlUnit = unit;
        this.runIntervalSeconds = runIntervalSeconds;
    }

    @Nonnull
    public TtlMode getTtlMode() {
        return this.ttlMode;
    }

    @Nonnull
    public TtlUnit getTtlUnit() {
        return this.ttlUnit;
    }

    @Nonnull
    public String getDateTimeColumn() {
        return this.dateTimeColumn;
    }

    @Nonnull
    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    @Nullable
    public Integer getRunIntervaelSeconds() {
        return this.runIntervalSeconds;
    }

    public TableTtl withRunIntervalSeconds(int seconds) {
        return new TableTtl(this.ttlMode, this.ttlUnit, this.dateTimeColumn, this.expireAfterSeconds, seconds);
    }

    public static TableTtl notSet() {
        return NOT_SET;
    }

    public static TableTtl dateTimeColumn(@Nonnull String columnName, int expireAfterSeconds) {
        return new TableTtl(TtlMode.DATE_TYPE_COLUMN, TtlUnit.UNSPECIFIED, columnName, expireAfterSeconds, null);
    }

    public static TableTtl valueSinceUnixEpoch(@Nonnull String columnName, TtlUnit unit, int expireAfterSeconds) {
        return new TableTtl(TtlMode.VALUE_SINCE_UNIX_EPOCH, unit, columnName, expireAfterSeconds, null);
    }

    public static enum TtlUnit {
        UNSPECIFIED,
        SECONDS,
        MILLISECONDS,
        MICROSECONDS,
        NANOSECONDS;

    }

    public static enum TtlMode {
        DATE_TYPE_COLUMN(1),
        VALUE_SINCE_UNIX_EPOCH(2),
        NOT_SET(0);

        private final int caseMapping;

        private TtlMode(int caseMapping) {
            this.caseMapping = caseMapping;
        }

        public static TtlMode forCase(int value) {
            for (TtlMode mode : TtlMode.values()) {
                if (mode.caseMapping != value) continue;
                return mode;
            }
            throw new IllegalArgumentException("No TTL mode defined for specified value");
        }
    }
}

