/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query.stats;

import java.util.Objects;
import tech.ydb.proto.YdbQueryStats;
import tech.ydb.table.query.stats.OperationStats;

public final class TableAccessStats {
    private final String name;
    private final OperationStats reads;
    private final OperationStats updates;
    private final OperationStats deletes;
    private final long partitionsCount;

    public TableAccessStats(YdbQueryStats.TableAccessStats protoAutoGenTableAccessStats) {
        this.name = protoAutoGenTableAccessStats.getName();
        this.reads = new OperationStats(protoAutoGenTableAccessStats.getReads());
        this.updates = new OperationStats(protoAutoGenTableAccessStats.getUpdates());
        this.deletes = new OperationStats(protoAutoGenTableAccessStats.getDeletes());
        this.partitionsCount = protoAutoGenTableAccessStats.getPartitionsCount();
    }

    public String getName() {
        return this.name;
    }

    public OperationStats getReads() {
        return this.reads;
    }

    public OperationStats getUpdates() {
        return this.updates;
    }

    public OperationStats getDeletes() {
        return this.deletes;
    }

    public long getPartitionsCount() {
        return this.partitionsCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TableAccessStats)) {
            return super.equals(obj);
        }
        TableAccessStats other = (TableAccessStats)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getReads(), other.getReads()) && Objects.equals(this.getUpdates(), other.getUpdates()) && Objects.equals(this.getDeletes(), other.getDeletes()) && Objects.equals(this.getPartitionsCount(), other.getPartitionsCount());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getReads(), this.getUpdates(), this.getDeletes(), this.getPartitionsCount());
    }

    public String toString() {
        return "TableAccessStats{name='" + this.name + '\'' + ", reads=" + this.reads + ", updates=" + this.updates + ", deletes=" + this.deletes + ", partitionsCount=" + this.partitionsCount + '}';
    }
}

