/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.impl;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.Result;
import tech.ydb.table.Session;
import tech.ydb.table.SessionPoolStats;
import tech.ydb.table.TableClient;
import tech.ydb.table.impl.pool.SessionPool;
import tech.ydb.table.impl.pool.SessionPoolOptions;
import tech.ydb.table.rpc.TableRpc;

public class PooledTableClient
implements TableClient {
    private final TableRpc tableRpc;
    private final SessionPool pool;

    protected PooledTableClient(Builder builder) {
        this.tableRpc = builder.tableRpc;
        this.pool = new SessionPool(Clock.systemUTC(), builder.tableRpc, builder.keepQueryText, builder.sessionPoolOptions);
    }

    @Override
    public CompletableFuture<Result<Session>> createSession(Duration timeout) {
        return this.pool.acquire(timeout);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.tableRpc.getScheduler();
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public void updatePoolMaxSize(int maxSize) {
        this.pool.updateMaxSize(maxSize);
    }

    @Override
    public SessionPoolStats sessionPoolStats() {
        return this.pool.stats();
    }

    public static Builder newClient(TableRpc rpc) {
        return new Builder(rpc);
    }

    public static class Builder
    implements TableClient.Builder {
        private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
        private static final Duration MAX_DURATION = Duration.ofMinutes(30L);
        private final TableRpc tableRpc;
        private boolean keepQueryText = true;
        private SessionPoolOptions sessionPoolOptions = SessionPoolOptions.DEFAULT;

        protected Builder(TableRpc tableRpc) {
            Preconditions.checkArgument((tableRpc != null ? 1 : 0) != 0, (Object)"table rpc is null");
            this.tableRpc = tableRpc;
        }

        private static String prettyDuration(Duration duration) {
            return duration.toString().substring(2).toLowerCase();
        }

        @Override
        public Builder keepQueryText(boolean keep) {
            this.keepQueryText = keep;
            return this;
        }

        @Override
        public Builder sessionPoolSize(int minSize, int maxSize) {
            Preconditions.checkArgument((minSize >= 0 ? 1 : 0) != 0, (String)"sessionPoolMinSize(%s) is negative", (int)minSize);
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (String)"sessionPoolMaxSize(%s) is negative or zero", (int)maxSize);
            Preconditions.checkArgument((minSize <= maxSize ? 1 : 0) != 0, (String)"sessionPoolMinSize(%s) is greater than sessionPoolMaxSize(%s)", (int)minSize, (int)maxSize);
            this.sessionPoolOptions = this.sessionPoolOptions.withSize(minSize, maxSize);
            return this;
        }

        @Override
        public Builder sessionKeepAliveTime(Duration duration) {
            Preconditions.checkArgument((!duration.isNegative() ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%s) is negative", (Object)Builder.prettyDuration(duration));
            Preconditions.checkArgument((duration.compareTo(MIN_DURATION) >= 0 ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%s) is less than minimal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MIN_DURATION));
            Preconditions.checkArgument((duration.compareTo(MAX_DURATION) <= 0 ? 1 : 0) != 0, (String)"sessionKeepAliveTime(%s) is greater than maximal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MAX_DURATION));
            this.sessionPoolOptions = this.sessionPoolOptions.withKeepAliveTimeMillis(duration.toMillis());
            return this;
        }

        @Override
        public Builder sessionMaxIdleTime(Duration duration) {
            Preconditions.checkArgument((!duration.isNegative() ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is negative", (Object)Builder.prettyDuration(duration));
            Preconditions.checkArgument((duration.compareTo(MIN_DURATION) >= 0 ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is less than minimal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MIN_DURATION));
            Preconditions.checkArgument((duration.compareTo(MAX_DURATION) <= 0 ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is greater than maximal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MAX_DURATION));
            this.sessionPoolOptions = this.sessionPoolOptions.withMaxIdleTimeMillis(duration.toMillis());
            return this;
        }

        @Override
        public PooledTableClient build() {
            return new PooledTableClient(this);
        }
    }
}

