/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.impl;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.Result;
import tech.ydb.core.StatusCode;
import tech.ydb.table.Session;
import tech.ydb.table.SessionSupplier;
import tech.ydb.table.impl.BaseSession;
import tech.ydb.table.rpc.TableRpc;
import tech.ydb.table.settings.CreateSessionSettings;
import tech.ydb.table.settings.DeleteSessionSettings;

public class SimpleTableClient
implements SessionSupplier {
    private final TableRpc tableRpc;
    private final boolean keepQueryText;

    private SimpleTableClient(Builder builder) {
        this.tableRpc = builder.tableRpc;
        this.keepQueryText = builder.keepQueryText;
    }

    @Override
    public CompletableFuture<Result<Session>> createSession(Duration duration) {
        CreateSessionSettings settings = (CreateSessionSettings)new CreateSessionSettings().setTimeout(duration);
        return BaseSession.createSessionId(this.tableRpc, settings, false).thenApply(response -> response.map(x$0 -> new SimpleSession((String)x$0)));
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.tableRpc.getScheduler();
    }

    public static Builder newClient(TableRpc rpc) {
        return new Builder(rpc);
    }

    private class SimpleSession
    extends BaseSession {
        SimpleSession(String id) {
            super(id, SimpleTableClient.this.tableRpc, SimpleTableClient.this.keepQueryText);
        }

        @Override
        protected void updateSessionState(Throwable th, StatusCode code, boolean shutdownHint) {
        }

        @Override
        public void close() {
            this.delete(new DeleteSessionSettings()).join();
        }
    }

    public static class Builder {
        private final TableRpc tableRpc;
        private boolean keepQueryText = true;

        public Builder(TableRpc tableRpc) {
            this.tableRpc = tableRpc;
        }

        public Builder keepQueryText(boolean keep) {
            this.keepQueryText = keep;
            return this;
        }

        public SimpleTableClient build() {
            return new SimpleTableClient(this);
        }
    }
}

