/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.transaction;

import java.util.concurrent.CompletableFuture;
import tech.ydb.common.transaction.YdbTransaction;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.table.Session;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.settings.CommitTxSettings;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.settings.RollbackTxSettings;

public interface TableTransaction
extends YdbTransaction {
    public Session getSession();

    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String var1, boolean var2, Params var3, ExecuteDataQuerySettings var4);

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query) {
        return this.executeDataQuery(query, false, Params.empty(), new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, Params params) {
        return this.executeDataQuery(query, false, params, new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQueryAndCommit(String query) {
        return this.executeDataQuery(query, true, Params.empty(), new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQueryAndCommit(String query, Params params) {
        return this.executeDataQuery(query, false, params, new ExecuteDataQuerySettings());
    }

    public CompletableFuture<Status> commit(CommitTxSettings var1);

    public CompletableFuture<Status> rollback(RollbackTxSettings var1);

    default public CompletableFuture<Status> commit() {
        return this.commit(new CommitTxSettings());
    }

    default public CompletableFuture<Status> rollback() {
        return this.rollback(new RollbackTxSettings());
    }
}

