/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import com.google.protobuf.Duration;
import java.util.Objects;
import tech.ydb.proto.table.YdbTable;

public class Changefeed {
    private final String name;
    private final Mode mode;
    private final Format format;
    private final boolean virtualTimestamps;
    private final java.time.Duration retentionPeriod;
    private final boolean initialScan;

    private Changefeed(Builder builder) {
        this.name = builder.name;
        this.mode = builder.mode;
        this.format = builder.format;
        this.virtualTimestamps = builder.virtualTimestamps;
        this.retentionPeriod = builder.retentionPeriod;
        this.initialScan = builder.initialScan;
    }

    public String getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean hasVirtualTimestamps() {
        return this.virtualTimestamps;
    }

    public boolean hasInitialScan() {
        return this.initialScan;
    }

    public java.time.Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public YdbTable.Changefeed toProto() {
        YdbTable.Changefeed.Builder builder = YdbTable.Changefeed.newBuilder().setName(this.name).setFormat(this.format.toProto()).setVirtualTimestamps(this.virtualTimestamps).setInitialScan(this.initialScan).setMode(this.mode.toPb());
        if (this.retentionPeriod != null) {
            builder.setRetentionPeriod(Duration.newBuilder().setSeconds(this.retentionPeriod.getSeconds()).setNanos(this.retentionPeriod.getNano()).build());
        }
        return builder.build();
    }

    public static Builder newBuilder(String changefeedName) {
        return new Builder(changefeedName);
    }

    public static class Builder {
        private final String name;
        private Mode mode = Mode.KEYS_ONLY;
        private Format format = Format.JSON;
        private boolean virtualTimestamps = false;
        private java.time.Duration retentionPeriod = null;
        private boolean initialScan = false;

        private Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder withMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder withVirtualTimestamps(boolean value) {
            this.virtualTimestamps = value;
            return this;
        }

        public Builder withInitialScan(boolean value) {
            this.initialScan = value;
            return this;
        }

        public Builder withRetentionPeriod(java.time.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Changefeed build() {
            return new Changefeed(this);
        }
    }

    public static enum Format {
        JSON(YdbTable.ChangefeedFormat.Format.FORMAT_JSON);

        private final YdbTable.ChangefeedFormat.Format proto;

        private Format(YdbTable.ChangefeedFormat.Format proto) {
            this.proto = proto;
        }

        YdbTable.ChangefeedFormat.Format toProto() {
            return this.proto;
        }
    }

    public static enum Mode {
        KEYS_ONLY(YdbTable.ChangefeedMode.Mode.MODE_KEYS_ONLY),
        UPDATES(YdbTable.ChangefeedMode.Mode.MODE_UPDATES),
        NEW_IMAGE(YdbTable.ChangefeedMode.Mode.MODE_NEW_IMAGE),
        OLD_IMAGE(YdbTable.ChangefeedMode.Mode.MODE_OLD_IMAGE),
        NEW_AND_OLD_IMAGES(YdbTable.ChangefeedMode.Mode.MODE_NEW_AND_OLD_IMAGES);

        private final YdbTable.ChangefeedMode.Mode proto;

        private Mode(YdbTable.ChangefeedMode.Mode proto) {
            this.proto = proto;
        }

        YdbTable.ChangefeedMode.Mode toPb() {
            return this.proto;
        }
    }
}

