/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.rpc.grpc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import tech.ydb.core.Operations;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.proto.table.YdbTable;
import tech.ydb.proto.table.v1.TableServiceGrpc;
import tech.ydb.table.rpc.TableRpc;

@ParametersAreNonnullByDefault
public final class GrpcTableRpc
implements TableRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcTableRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    public static GrpcTableRpc useTransport(@WillNotClose GrpcTransport transport) {
        return new GrpcTableRpc(transport, false);
    }

    public static GrpcTableRpc ownTransport(@WillClose GrpcTransport transport) {
        return new GrpcTableRpc(transport, true);
    }

    @Override
    public CompletableFuture<Result<YdbTable.CreateSessionResult>> createSession(YdbTable.CreateSessionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCreateSessionMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.CreateSessionResponse::getOperation, YdbTable.CreateSessionResult.class));
    }

    @Override
    public CompletableFuture<Status> deleteSession(YdbTable.DeleteSessionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDeleteSessionMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.DeleteSessionResponse::getOperation));
    }

    @Override
    public CompletableFuture<Result<YdbTable.KeepAliveResult>> keepAlive(YdbTable.KeepAliveRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getKeepAliveMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.KeepAliveResponse::getOperation, YdbTable.KeepAliveResult.class));
    }

    @Override
    public CompletableFuture<Status> createTable(YdbTable.CreateTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCreateTableMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.CreateTableResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> dropTable(YdbTable.DropTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDropTableMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.DropTableResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> alterTable(YdbTable.AlterTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getAlterTableMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.AlterTableResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> copyTable(YdbTable.CopyTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCopyTableMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.CopyTableResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> copyTables(YdbTable.CopyTablesRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCopyTablesMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.CopyTablesResponse::getOperation));
    }

    @Override
    public CompletableFuture<Result<YdbTable.DescribeTableResult>> describeTable(YdbTable.DescribeTableRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getDescribeTableMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.DescribeTableResponse::getOperation, YdbTable.DescribeTableResult.class));
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExplainQueryResult>> explainDataQuery(YdbTable.ExplainDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExplainDataQueryMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.ExplainDataQueryResponse::getOperation, YdbTable.ExplainQueryResult.class));
    }

    @Override
    public CompletableFuture<Result<YdbTable.PrepareQueryResult>> prepareDataQuery(YdbTable.PrepareDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getPrepareDataQueryMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.PrepareDataQueryResponse::getOperation, YdbTable.PrepareQueryResult.class));
    }

    @Override
    public CompletableFuture<Result<YdbTable.ExecuteQueryResult>> executeDataQuery(YdbTable.ExecuteDataQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExecuteDataQueryMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.ExecuteDataQueryResponse::getOperation, YdbTable.ExecuteQueryResult.class));
    }

    @Override
    public CompletableFuture<Status> executeSchemeQuery(YdbTable.ExecuteSchemeQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getExecuteSchemeQueryMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.ExecuteSchemeQueryResponse::getOperation));
    }

    @Override
    public CompletableFuture<Result<YdbTable.BeginTransactionResult>> beginTransaction(YdbTable.BeginTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getBeginTransactionMethod(), settings, (Object)request).thenApply(Operations.resultUnwrapper(YdbTable.BeginTransactionResponse::getOperation, YdbTable.BeginTransactionResult.class));
    }

    @Override
    public CompletableFuture<Status> commitTransaction(YdbTable.CommitTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getCommitTransactionMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.CommitTransactionResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> rollbackTransaction(YdbTable.RollbackTransactionRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getRollbackTransactionMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.RollbackTransactionResponse::getOperation));
    }

    @Override
    public GrpcReadStream<YdbTable.ReadTableResponse> streamReadTable(YdbTable.ReadTableRequest request, GrpcRequestSettings settings) {
        return this.transport.readStreamCall(TableServiceGrpc.getStreamReadTableMethod(), settings, (Object)request);
    }

    @Override
    public GrpcReadStream<YdbTable.ExecuteScanQueryPartialResponse> streamExecuteScanQuery(YdbTable.ExecuteScanQueryRequest request, GrpcRequestSettings settings) {
        return this.transport.readStreamCall(TableServiceGrpc.getStreamExecuteScanQueryMethod(), settings, (Object)request);
    }

    @Override
    public CompletableFuture<Status> bulkUpsert(YdbTable.BulkUpsertRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(TableServiceGrpc.getBulkUpsertMethod(), settings, (Object)request).thenApply(Operations.statusUnwrapper(YdbTable.BulkUpsertResponse::getOperation));
    }

    @Override
    public String getDatabase() {
        return this.transport.getDatabase();
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.transport.getScheduler();
    }

    @Override
    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

