/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.result.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.result.impl.AbstractValueReader;
import tech.ydb.table.result.impl.ProtoDictValueReader;
import tech.ydb.table.result.impl.ProtoListValueReader;
import tech.ydb.table.result.impl.ProtoOptionalValueReader;
import tech.ydb.table.result.impl.ProtoPrimitiveValueReader;
import tech.ydb.table.result.impl.ProtoResultSetReader;
import tech.ydb.table.result.impl.ProtoStructValueReader;
import tech.ydb.table.result.impl.ProtoTupleValueReader;
import tech.ydb.table.result.impl.ProtoVariantValueReader;
import tech.ydb.table.result.impl.ProtoVoidValueReader;

public class ProtoValueReaders {
    private ProtoValueReaders() {
    }

    public static ResultSetReader forResultSet(ValueProtos.ResultSet resultSet) {
        return new ProtoResultSetReader(resultSet);
    }

    public static ResultSetReader forResultSets(Collection<ResultSetReader> resultSets) {
        Preconditions.checkArgument((!resultSets.isEmpty() ? 1 : 0) != 0, (Object)"Expect multiple result sets to join from");
        Iterator<ResultSetReader> iterator = resultSets.iterator();
        if (resultSets.size() == 1) {
            return ProtoValueReaders.castAsProtoReader(iterator.next());
        }
        ValueProtos.ResultSet.Builder builder = ProtoValueReaders.castAsProtoReader(iterator.next()).getResultSet().toBuilder();
        while (iterator.hasNext()) {
            ValueProtos.ResultSet resultSet = ProtoValueReaders.castAsProtoReader(iterator.next()).getResultSet();
            if (resultSet.getTruncated()) {
                builder.setTruncated(true);
            }
            builder.addAllRows((Iterable)resultSet.getRowsList());
        }
        return new ProtoResultSetReader(builder.build());
    }

    public static ValueReader forType(ValueProtos.Type type) {
        return ProtoValueReaders.forTypeImpl(type);
    }

    static AbstractValueReader forTypeImpl(ValueProtos.Type type) {
        switch (type.getTypeCase()) {
            case TYPE_ID: 
            case DECIMAL_TYPE: {
                return new ProtoPrimitiveValueReader(type);
            }
            case OPTIONAL_TYPE: {
                return ProtoValueReaders.optionalReader(type);
            }
            case TUPLE_TYPE: {
                return ProtoValueReaders.tupleReader(type);
            }
            case DICT_TYPE: {
                return ProtoValueReaders.dictReader(type);
            }
            case LIST_TYPE: {
                return ProtoValueReaders.listReader(type);
            }
            case STRUCT_TYPE: {
                return ProtoValueReaders.structReader(type);
            }
            case VARIANT_TYPE: {
                return ProtoValueReaders.variantReader(type);
            }
            case VOID_TYPE: {
                return ProtoVoidValueReader.INSTANCE;
            }
        }
        throw new IllegalStateException("unsupported type: " + type);
    }

    private static AbstractValueReader variantReader(ValueProtos.Type type) {
        ValueProtos.VariantType variantType = type.getVariantType();
        if (variantType.hasStructItems()) {
            ValueProtos.StructType structItems = variantType.getStructItems();
            AbstractValueReader[] itemReaders = new AbstractValueReader[structItems.getMembersCount()];
            for (int i = 0; i < structItems.getMembersCount(); ++i) {
                itemReaders[i] = ProtoValueReaders.forTypeImpl(structItems.getMembers(i).getType());
            }
            return new ProtoVariantValueReader(type, itemReaders);
        }
        if (variantType.hasTupleItems()) {
            ValueProtos.TupleType tupleItems = variantType.getTupleItems();
            AbstractValueReader[] itemReaders = new AbstractValueReader[tupleItems.getElementsCount()];
            for (int i = 0; i < tupleItems.getElementsCount(); ++i) {
                itemReaders[i] = ProtoValueReaders.forTypeImpl(tupleItems.getElements(i));
            }
            return new ProtoVariantValueReader(type, itemReaders);
        }
        throw new IllegalStateException("empty variant type");
    }

    private static AbstractValueReader structReader(ValueProtos.Type type) {
        ValueProtos.StructType structType = type.getStructType();
        int membersCount = structType.getMembersCount();
        AbstractValueReader[] memberReaders = new AbstractValueReader[membersCount];
        for (int i = 0; i < membersCount; ++i) {
            memberReaders[i] = ProtoValueReaders.forTypeImpl(structType.getMembers(i).getType());
        }
        return new ProtoStructValueReader(type, memberReaders);
    }

    private static AbstractValueReader listReader(ValueProtos.Type type) {
        ValueProtos.ListType listType = type.getListType();
        return new ProtoListValueReader(type, ProtoValueReaders.forTypeImpl(listType.getItem()));
    }

    private static AbstractValueReader dictReader(ValueProtos.Type type) {
        ValueProtos.DictType dictType = type.getDictType();
        return new ProtoDictValueReader(type, ProtoValueReaders.forTypeImpl(dictType.getKey()), ProtoValueReaders.forTypeImpl(dictType.getPayload()));
    }

    private static AbstractValueReader optionalReader(ValueProtos.Type type) {
        ValueProtos.Type itemType = type.getOptionalType().getItem();
        switch (itemType.getTypeCase()) {
            case TYPE_ID: 
            case DECIMAL_TYPE: {
                return new ProtoPrimitiveValueReader.Optional(type);
            }
        }
        return new ProtoOptionalValueReader(type, ProtoValueReaders.forTypeImpl(itemType));
    }

    private static AbstractValueReader tupleReader(ValueProtos.Type type) {
        ValueProtos.TupleType tupleType = type.getTupleType();
        int elementsCount = tupleType.getElementsCount();
        AbstractValueReader[] elementReaders = new AbstractValueReader[elementsCount];
        for (int i = 0; i < elementsCount; ++i) {
            elementReaders[i] = ProtoValueReaders.forTypeImpl(tupleType.getElements(i));
        }
        return new ProtoTupleValueReader(type, elementReaders);
    }

    private static ProtoResultSetReader castAsProtoReader(ResultSetReader reader) {
        Preconditions.checkState((boolean)(reader instanceof ProtoResultSetReader), (String)"Expect %s class to join from resultSets", ProtoResultSetReader.class);
        return (ProtoResultSetReader)reader;
    }
}

