/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query.stats;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tech.ydb.proto.YdbQueryStats;
import tech.ydb.table.query.stats.CompilationStats;
import tech.ydb.table.query.stats.QueryPhaseStats;

public final class QueryStats
implements Serializable {
    private final List<QueryPhaseStats> queryPhases;
    private final CompilationStats compilation;
    private final long processCpuTimeUs;
    private final String queryPlan;
    private final String queryAst;
    private final long totalDurationUs;
    private final long totalCpuTimeUs;

    public QueryStats(YdbQueryStats.QueryStats protoAutoGenQueryStats) {
        this.queryPhases = protoAutoGenQueryStats.getQueryPhasesList().stream().map(QueryPhaseStats::new).collect(Collectors.toList());
        this.compilation = new CompilationStats(protoAutoGenQueryStats.getCompilation());
        this.processCpuTimeUs = protoAutoGenQueryStats.getProcessCpuTimeUs();
        this.queryPlan = protoAutoGenQueryStats.getQueryPlan();
        this.queryAst = protoAutoGenQueryStats.getQueryAst();
        this.totalDurationUs = protoAutoGenQueryStats.getTotalDurationUs();
        this.totalCpuTimeUs = protoAutoGenQueryStats.getProcessCpuTimeUs();
    }

    public List<QueryPhaseStats> getQueryPhasesList() {
        return this.queryPhases;
    }

    public int getQueryPhasesCount() {
        return this.queryPhases.size();
    }

    public QueryPhaseStats getQueryPhases(int index) {
        return this.queryPhases.get(index);
    }

    public boolean hasCompilation() {
        return this.compilation != null;
    }

    public CompilationStats getCompilation() {
        return this.compilation;
    }

    public long getProcessCpuTimeUs() {
        return this.processCpuTimeUs;
    }

    public long getTotalDurationUs() {
        return this.totalDurationUs;
    }

    public long getTotalCpuTimeUs() {
        return this.totalCpuTimeUs;
    }

    public String getQueryAst() {
        return this.queryAst;
    }

    public String getQueryPlan() {
        return this.queryPlan;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryStats)) {
            return super.equals(obj);
        }
        QueryStats other = (QueryStats)obj;
        return Objects.equals(this.getQueryPhasesList(), other.getQueryPhasesList()) && Objects.equals(this.getCompilation(), other.getCompilation()) && Objects.equals(this.getProcessCpuTimeUs(), other.getProcessCpuTimeUs()) && Objects.equals(this.getQueryPlan(), other.getQueryPlan()) && Objects.equals(this.getQueryAst(), other.getQueryAst()) && Objects.equals(this.getTotalDurationUs(), other.getTotalDurationUs()) && Objects.equals(this.getTotalCpuTimeUs(), other.getTotalCpuTimeUs());
    }

    public int hashCode() {
        return Objects.hash(this.getQueryPhasesList(), this.getCompilation(), this.getProcessCpuTimeUs(), this.getQueryPlan(), this.getQueryAst(), this.getTotalDurationUs(), this.getTotalCpuTimeUs());
    }

    public String toString() {
        return "QueryStats{queryPhases=" + this.queryPhases + ", compilation=" + this.compilation + ", processCpuTimeUs=" + this.processCpuTimeUs + ", queryPlan='" + this.queryPlan + '\'' + ", queryAst='" + this.queryAst + '\'' + ", totalDurationUs=" + this.totalDurationUs + ", totalCpuTimeUs=" + this.totalCpuTimeUs + '}';
    }
}

