/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query.stats;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import tech.ydb.proto.YdbQueryStats;
import tech.ydb.table.query.stats.TableAccessStats;

public final class QueryPhaseStats
implements Serializable {
    private final long durationUs;
    private final List<TableAccessStats> tableAccess;
    private final long cpuTimeUs;
    private final long affectedShards;
    private final boolean literalPhase;

    public QueryPhaseStats(YdbQueryStats.QueryPhaseStats protoAutoGenQueryPhaseStats) {
        this.durationUs = protoAutoGenQueryPhaseStats.getDurationUs();
        this.tableAccess = protoAutoGenQueryPhaseStats.getTableAccessList().stream().map(TableAccessStats::new).collect(Collectors.toList());
        this.cpuTimeUs = protoAutoGenQueryPhaseStats.getCpuTimeUs();
        this.affectedShards = protoAutoGenQueryPhaseStats.getAffectedShards();
        this.literalPhase = protoAutoGenQueryPhaseStats.getLiteralPhase();
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public List<TableAccessStats> getTableAccessList() {
        return this.tableAccess;
    }

    public int getTableAccessCount() {
        return this.tableAccess.size();
    }

    public TableAccessStats getTableAccess(int index) {
        return this.tableAccess.get(index);
    }

    public long getCpuTimeUs() {
        return this.cpuTimeUs;
    }

    public long getAffectedShards() {
        return this.affectedShards;
    }

    public boolean getLiteralPhase() {
        return this.literalPhase;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryPhaseStats)) {
            return super.equals(obj);
        }
        QueryPhaseStats other = (QueryPhaseStats)obj;
        return Objects.equals(this.getDurationUs(), other.getDurationUs()) && Objects.equals(this.getTableAccessList(), other.getTableAccessList()) && Objects.equals(this.getCpuTimeUs(), other.getCpuTimeUs()) && Objects.equals(this.getAffectedShards(), other.getAffectedShards()) && Objects.equals(this.getLiteralPhase(), other.getLiteralPhase());
    }

    public int hashCode() {
        return Objects.hash(this.getDurationUs(), this.getTableAccessList(), this.getCpuTimeUs(), this.getAffectedShards(), this.getLiteralPhase());
    }

    public String toString() {
        return "QueryPhaseStats{durationUs=" + this.durationUs + ", tableAccess=" + this.tableAccess + ", cpuTimeUs=" + this.cpuTimeUs + ", affectedShards=" + this.affectedShards + ", literalPhase=" + this.literalPhase + '}';
    }
}

