/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.result;

import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import tech.ydb.table.values.DecimalValue;

public interface PrimitiveReader {
    public boolean getBool();

    public byte getInt8();

    public int getUint8();

    public short getInt16();

    public int getUint16();

    public int getInt32();

    public long getUint32();

    public long getInt64();

    public long getUint64();

    public float getFloat();

    public double getDouble();

    public LocalDate getDate();

    public LocalDateTime getDatetime();

    public Instant getTimestamp();

    public Duration getInterval();

    public ZonedDateTime getTzDate();

    public ZonedDateTime getTzDatetime();

    public ZonedDateTime getTzTimestamp();

    public byte[] getBytes();

    default public String getBytesAsString(Charset charset) {
        return new String(this.getBytes(), charset);
    }

    public UUID getUuid();

    public String getText();

    public byte[] getYson();

    public String getJson();

    public String getJsonDocument();

    public DecimalValue getDecimal();
}

