/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.impl;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.proto.query.YdbQuery;
import tech.ydb.proto.table.YdbTable;
import tech.ydb.query.QuerySession;
import tech.ydb.query.impl.QueryClientImpl;
import tech.ydb.query.impl.SessionImpl;
import tech.ydb.query.impl.TxControl;
import tech.ydb.query.settings.ExecuteQuerySettings;
import tech.ydb.query.tools.QueryReader;
import tech.ydb.table.Session;
import tech.ydb.table.SessionPoolStats;
import tech.ydb.table.TableClient;
import tech.ydb.table.impl.BaseSession;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.query.stats.QueryStats;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.rpc.TableRpc;
import tech.ydb.table.rpc.grpc.GrpcTableRpc;
import tech.ydb.table.settings.ExecuteDataQuerySettings;

public class TableClientImpl
implements TableClient {
    private final TableRpc rpc;
    private final QueryClientImpl proxy;

    TableClientImpl(Builder builder) {
        this.rpc = builder.rpc;
        this.proxy = new QueryClientImpl(builder.query);
    }

    public ScheduledExecutorService getScheduler() {
        return this.proxy.getScheduler();
    }

    public SessionPoolStats sessionPoolStats() {
        return this.proxy.getSessionPoolStats();
    }

    public CompletableFuture<Result<Session>> createSession(Duration duration) {
        return this.proxy.createSession(duration).thenApply(r -> r.map(x$0 -> new TableSession((QuerySession)x$0)));
    }

    public void close() {
        this.proxy.close();
    }

    private YdbQuery.TransactionControl mapTxControl(YdbTable.TransactionControl tc) {
        if (tc.hasTxId()) {
            return TxControl.txIdCtrl(tc.getTxId(), tc.getCommitTx());
        }
        if (tc.hasBeginTx()) {
            if (tc.getBeginTx().hasSerializableReadWrite()) {
                return TxControl.txModeCtrl(TxMode.SERIALIZABLE_RW, tc.getCommitTx());
            }
            if (tc.getBeginTx().hasSnapshotReadOnly()) {
                return TxControl.txModeCtrl(TxMode.SNAPSHOT_RO, tc.getCommitTx());
            }
            if (tc.getBeginTx().hasStaleReadOnly()) {
                return TxControl.txModeCtrl(TxMode.STALE_RO, tc.getCommitTx());
            }
            if (tc.getBeginTx().hasOnlineReadOnly()) {
                if (tc.getBeginTx().getOnlineReadOnly().getAllowInconsistentReads()) {
                    return TxControl.txModeCtrl(TxMode.ONLINE_INCONSISTENT_RO, tc.getCommitTx());
                }
                return TxControl.txModeCtrl(TxMode.ONLINE_RO, tc.getCommitTx());
            }
        }
        return TxControl.txModeCtrl(TxMode.NONE, tc.getCommitTx());
    }

    public static Builder newClient(GrpcTransport transport) {
        return new Builder(transport);
    }

    public static class Builder
    implements TableClient.Builder {
        private final TableRpc rpc;
        private final QueryClientImpl.Builder query;

        protected Builder(GrpcTransport transport) {
            this.rpc = GrpcTableRpc.useTransport((GrpcTransport)transport);
            this.query = new QueryClientImpl.Builder(transport);
        }

        public Builder keepQueryText(boolean keep) {
            return this;
        }

        public Builder sessionPoolSize(int minSize, int maxSize) {
            this.query.sessionPoolMaxSize(maxSize).sessionPoolMinSize(minSize);
            return this;
        }

        public Builder sessionKeepAliveTime(Duration duration) {
            return this;
        }

        public Builder sessionMaxIdleTime(Duration duration) {
            this.query.sessionMaxIdleTime(duration);
            return this;
        }

        public TableClientImpl build() {
            return new TableClientImpl(this);
        }
    }

    private class TableSession
    extends BaseSession {
        private final SessionImpl querySession;

        TableSession(QuerySession session) {
            super(session.getId(), TableClientImpl.this.rpc, false);
            this.querySession = (SessionImpl)session;
        }

        public CompletableFuture<Result<DataQueryResult>> executeDataQueryInternal(String query, YdbTable.TransactionControl tx, Params prms, ExecuteDataQuerySettings settings) {
            YdbQuery.TransactionControl tc = TableClientImpl.this.mapTxControl(tx);
            ExecuteQuerySettings qs = ((ExecuteQuerySettings.Builder)((ExecuteQuerySettings.Builder)ExecuteQuerySettings.newBuilder().withTraceId(settings.getTraceId())).withRequestTimeout(settings.getTimeoutDuration())).build();
            final AtomicReference<String> txRef = new AtomicReference<String>("");
            SessionImpl sessionImpl = this.querySession;
            sessionImpl.getClass();
            SessionImpl.StreamImpl stream = new SessionImpl.StreamImpl(sessionImpl, this.querySession.createGrpcStream(query, tc, prms, qs)){
                {
                    SessionImpl sessionImpl = x0;
                    sessionImpl.getClass();
                    super(sessionImpl, (GrpcReadStream<YdbQuery.ExecuteQueryResponsePart>)grpcStream);
                }

                @Override
                void handleTxMeta(String txID) {
                    txRef.set(txID);
                }
            };
            return QueryReader.readFrom(stream).thenApply(r -> r.map(reader -> new ProxedDataQueryResult((String)txRef.get(), (QueryReader)reader)));
        }

        protected void updateSessionState(Throwable th, StatusCode code, boolean shutdownHint) {
            if (code != null) {
                this.querySession.updateSessionState(Status.of((StatusCode)code));
                return;
            }
            while (th != null) {
                if (th instanceof UnexpectedResultException) {
                    UnexpectedResultException unexpected = (UnexpectedResultException)th;
                    this.querySession.updateSessionState(unexpected.getStatus());
                }
                th = th.getCause();
            }
        }

        public void close() {
            this.querySession.close();
        }
    }

    private class ProxedDataQueryResult
    extends DataQueryResult {
        private final String txID;
        private final QueryReader reader;

        ProxedDataQueryResult(String txID, QueryReader reader) {
            super(YdbTable.ExecuteQueryResult.getDefaultInstance());
            this.txID = txID;
            this.reader = reader;
        }

        public String getTxId() {
            return this.txID;
        }

        public int getResultSetCount() {
            return this.reader.getResultSetCount();
        }

        public ResultSetReader getResultSet(int index) {
            return this.reader.getResultSet(index);
        }

        public boolean isTruncated(int index) {
            return false;
        }

        public int getRowCount(int index) {
            return this.reader.getResultSet(index).getRowCount();
        }

        public boolean isEmpty() {
            return this.txID.isEmpty() && this.reader.getResultSetCount() == 0;
        }

        public QueryStats getQueryStats() {
            return null;
        }

        public boolean hasQueryStats() {
            return false;
        }
    }
}

