/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.impl;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.Result;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.query.QueryClient;
import tech.ydb.query.QuerySession;
import tech.ydb.query.impl.QueryServiceRpc;
import tech.ydb.query.impl.SessionPool;
import tech.ydb.table.SessionPoolStats;

public class QueryClientImpl
implements QueryClient {
    private final SessionPool pool;
    private final ScheduledExecutorService scheduler;

    public QueryClientImpl(Builder builder) {
        this.pool = new SessionPool(Clock.systemUTC(), new QueryServiceRpc(builder.transport), builder.transport.getScheduler(), builder.sessionPoolMinSize, builder.sessionPoolMaxSize, builder.sessionPoolIdleDuration);
        this.scheduler = builder.transport.getScheduler();
    }

    @Override
    public CompletableFuture<Result<QuerySession>> createSession(Duration timeout) {
        return this.pool.acquire(timeout);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void updatePoolMaxSize(int maxSize) {
        this.pool.updateMaxSize(maxSize);
    }

    public SessionPoolStats getSessionPoolStats() {
        return this.pool.getStats();
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public static Builder newClient(GrpcTransport transport) {
        return new Builder(transport);
    }

    public static class Builder
    implements QueryClient.Builder {
        private static final Duration MAX_DURATION = Duration.ofMinutes(30L);
        private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
        private final GrpcTransport transport;
        private int sessionPoolMinSize = 0;
        private int sessionPoolMaxSize = 50;
        private Duration sessionPoolIdleDuration = Duration.ofMinutes(5L);

        Builder(GrpcTransport transport) {
            Preconditions.checkArgument((transport != null ? 1 : 0) != 0, (Object)"transport is null");
            this.transport = transport;
        }

        private static String prettyDuration(Duration duration) {
            return duration.toString().substring(2).toLowerCase();
        }

        @Override
        public Builder sessionPoolMinSize(int minSize) {
            Preconditions.checkArgument((minSize >= 0 ? 1 : 0) != 0, (String)"sessionPoolMinSize(%s) is negative", (int)minSize);
            Preconditions.checkArgument((minSize <= this.sessionPoolMaxSize ? 1 : 0) != 0, (String)"sessionPoolMinSize(%s) is greater than sessionPoolMaxSize(%s)", (int)minSize, (int)this.sessionPoolMaxSize);
            this.sessionPoolMinSize = minSize;
            return this;
        }

        @Override
        public Builder sessionPoolMaxSize(int maxSize) {
            Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (String)"sessionPoolMaxSize(%s) is negative or zero", (int)maxSize);
            Preconditions.checkArgument((this.sessionPoolMinSize <= maxSize ? 1 : 0) != 0, (String)"sessionPoolMinSize(%s) is greater than sessionPoolMaxSize(%s)", (int)this.sessionPoolMinSize, (int)maxSize);
            this.sessionPoolMaxSize = maxSize;
            return this;
        }

        @Override
        public Builder sessionMaxIdleTime(Duration duration) {
            Preconditions.checkArgument((!duration.isNegative() ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is negative", (Object)Builder.prettyDuration(duration));
            Preconditions.checkArgument((duration.compareTo(MIN_DURATION) >= 0 ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is less than minimal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MIN_DURATION));
            Preconditions.checkArgument((duration.compareTo(MAX_DURATION) <= 0 ? 1 : 0) != 0, (String)"sessionMaxIdleTime(%s) is greater than maximal duration %s", (Object)Builder.prettyDuration(duration), (Object)Builder.prettyDuration(MAX_DURATION));
            this.sessionPoolIdleDuration = duration;
            return this;
        }

        @Override
        public QueryClientImpl build() {
            return new QueryClientImpl(this);
        }
    }
}

