/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.query.QueryStream;
import tech.ydb.query.result.QueryInfo;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.Type;

public class QueryReader
implements Iterable<ResultSetReader> {
    private final QueryInfo info;
    private final List<Issue> issues;
    private final List<ResultSetReader> results;

    private QueryReader(QueryInfo info, List<Issue> issues, List<ResultSetReader> results) {
        this.info = info;
        this.issues = issues;
        this.results = results;
    }

    public QueryInfo getQueryInfo() {
        return this.info;
    }

    public int getResultSetCount() {
        return this.results.size();
    }

    public ResultSetReader getResultSet(int index) {
        return this.results.get(index);
    }

    public List<Issue> getIssueList() {
        return this.issues;
    }

    public static CompletableFuture<Result<QueryReader>> readFrom(QueryStream stream) {
        PartsCollector collector = new PartsCollector();
        return stream.execute(collector).thenApply(res -> res.map(collector::toReader));
    }

    @Override
    @Nonnull
    public Iterator<ResultSetReader> iterator() {
        return this.results.iterator();
    }

    private static class CompositeResultSet
    implements ResultSetReader {
        private final ResultSetReader[] parts;
        private final int rowsCount;
        private int partIndex = -1;

        CompositeResultSet(List<QueryResultPart> list) {
            this.parts = new ResultSetReader[list.size()];
            int count = 0;
            int idx = 0;
            for (QueryResultPart part : list) {
                this.parts[idx++] = part.getResultSetReader();
                count += part.getResultSetRowsCount();
            }
            this.rowsCount = count;
            this.partIndex = list.isEmpty() ? -1 : 0;
        }

        public boolean isTruncated() {
            return false;
        }

        public int getColumnCount() {
            if (this.partIndex < 0) {
                return 0;
            }
            return this.parts[this.partIndex].getColumnCount();
        }

        public String getColumnName(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts[this.partIndex].getColumnName(index);
        }

        public int getColumnIndex(String name) {
            if (this.partIndex < 0) {
                return -1;
            }
            return this.parts[this.partIndex].getColumnIndex(name);
        }

        public ValueReader getColumn(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts[this.partIndex].getColumn(index);
        }

        public ValueReader getColumn(String name) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts[this.partIndex].getColumn(name);
        }

        public Type getColumnType(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts[this.partIndex].getColumnType(index);
        }

        public int getRowCount() {
            return this.rowsCount;
        }

        public void setRowIndex(int index) {
            int currentIdx = Math.max(0, index);
            this.partIndex = 0;
            while (this.partIndex < this.parts.length) {
                int readerRows = this.parts[this.partIndex].getRowCount();
                if (currentIdx < readerRows) {
                    this.parts[this.partIndex].setRowIndex(currentIdx);
                    break;
                }
                this.parts[this.partIndex].setRowIndex(readerRows);
                currentIdx -= readerRows;
                ++this.partIndex;
            }
            if (this.partIndex >= this.parts.length) {
                this.partIndex = this.parts.length - 1;
            }
            for (int partStep = this.partIndex + 1; partStep < this.parts.length; ++partStep) {
                this.parts[partStep].setRowIndex(0);
            }
        }

        public boolean next() {
            if (this.partIndex < 0) {
                return false;
            }
            boolean res = this.parts[this.partIndex].next();
            while (!res && this.partIndex < this.parts.length - 1) {
                ++this.partIndex;
                res = this.parts[this.partIndex].next();
            }
            return res;
        }
    }

    private static class PartsCollector
    implements QueryStream.PartsHandler {
        private final List<Issue> issueList = new ArrayList<Issue>();
        private final SortedMap<Long, List<QueryResultPart>> results = new TreeMap<Long, List<QueryResultPart>>();

        private PartsCollector() {
        }

        QueryReader toReader(QueryInfo info) {
            ArrayList<List<Object>> ordered = new ArrayList<List<Object>>();
            long lastInserted = 0L;
            for (Map.Entry<Long, List<QueryResultPart>> entry : this.results.entrySet()) {
                long l = entry.getKey();
                while (lastInserted + 1L < l) {
                    ordered.add(new ArrayList());
                    ++lastInserted;
                }
                ordered.add(entry.getValue());
                lastInserted = l;
            }
            ArrayList<CompositeResultSet> resultsList = new ArrayList<CompositeResultSet>(ordered.size());
            for (List list : ordered) {
                resultsList.add(new CompositeResultSet(list));
            }
            return new QueryReader(info, this.issueList, resultsList);
        }

        @Override
        public void onIssues(Issue[] issues) {
            this.issueList.addAll(Arrays.asList(issues));
        }

        @Override
        public void onNextPart(QueryResultPart part) {
            Long index = part.getResultSetIndex();
            if (!this.results.containsKey(index)) {
                this.results.put(index, new ArrayList());
            }
            ((List)this.results.get(index)).add(part);
        }
    }
}

