/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.settings;

import tech.ydb.core.grpc.GrpcFlowControl;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.query.settings.QueryExecMode;
import tech.ydb.query.settings.QueryStatsMode;

public class ExecuteQuerySettings
extends BaseRequestSettings {
    private final QueryExecMode execMode;
    private final QueryStatsMode statsMode;
    private final boolean concurrentResultSets;
    private final String resourcePool;
    private final GrpcFlowControl flowControl;
    private final long partBytesLimit;

    private ExecuteQuerySettings(Builder builder) {
        super((BaseRequestSettings.BaseBuilder)builder);
        this.execMode = builder.execMode;
        this.statsMode = builder.statsMode;
        this.concurrentResultSets = builder.concurrentResultSets;
        this.resourcePool = builder.resourcePool;
        this.flowControl = builder.flowControl;
        this.partBytesLimit = builder.partBytesLimit;
    }

    public QueryExecMode getExecMode() {
        return this.execMode;
    }

    public QueryStatsMode getStatsMode() {
        return this.statsMode;
    }

    public boolean isConcurrentResultSets() {
        return this.concurrentResultSets;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public GrpcFlowControl getGrpcFlowControl() {
        return this.flowControl;
    }

    public long getPartBytesLimit() {
        return this.partBytesLimit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends BaseRequestSettings.BaseBuilder<Builder> {
        private QueryExecMode execMode = QueryExecMode.EXECUTE;
        private QueryStatsMode statsMode = QueryStatsMode.NONE;
        private boolean concurrentResultSets = false;
        private String resourcePool = null;
        private GrpcFlowControl flowControl = null;
        private long partBytesLimit = -1L;

        public Builder withExecMode(QueryExecMode mode) {
            this.execMode = mode;
            return this;
        }

        public Builder withStatsMode(QueryStatsMode mode) {
            this.statsMode = mode;
            return this;
        }

        public Builder withConcurrentResultSets(boolean value) {
            this.concurrentResultSets = value;
            return this;
        }

        public Builder withResourcePool(String poolId) {
            this.resourcePool = poolId;
            return this;
        }

        public Builder withGrpcFlowControl(GrpcFlowControl ctrl) {
            this.flowControl = ctrl;
            return this;
        }

        public Builder withPartBytesLimit(long limit) {
            this.partBytesLimit = limit;
            return this;
        }

        public ExecuteQuerySettings build() {
            return new ExecuteQuerySettings(this);
        }
    }
}

