/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.impl;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.common.transaction.impl.YdbTransactionImpl;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.impl.call.ProxyReadStream;
import tech.ydb.core.operation.StatusExtractor;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.core.utils.URITools;
import tech.ydb.proto.StatusCodesProtos;
import tech.ydb.proto.query.YdbQuery;
import tech.ydb.query.QuerySession;
import tech.ydb.query.QueryStream;
import tech.ydb.query.QueryTransaction;
import tech.ydb.query.impl.QueryServiceRpc;
import tech.ydb.query.impl.TxControl;
import tech.ydb.query.result.QueryInfo;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.query.result.QueryStats;
import tech.ydb.query.settings.AttachSessionSettings;
import tech.ydb.query.settings.BeginTransactionSettings;
import tech.ydb.query.settings.CommitTransactionSettings;
import tech.ydb.query.settings.CreateSessionSettings;
import tech.ydb.query.settings.DeleteSessionSettings;
import tech.ydb.query.settings.ExecuteQuerySettings;
import tech.ydb.query.settings.QueryExecMode;
import tech.ydb.query.settings.QueryStatsMode;
import tech.ydb.query.settings.RollbackTransactionSettings;
import tech.ydb.table.query.Params;

abstract class SessionImpl
implements QuerySession {
    private static final String SERVER_BALANCER_HINT = "session-balancer";
    private static final Logger logger = LoggerFactory.getLogger(QuerySession.class);
    private static final StatusExtractor<YdbQuery.CreateSessionResponse> CREATE_SESSION = StatusExtractor.of(YdbQuery.CreateSessionResponse::getStatus, YdbQuery.CreateSessionResponse::getIssuesList);
    private static final StatusExtractor<YdbQuery.DeleteSessionResponse> DELETE_SESSION = StatusExtractor.of(YdbQuery.DeleteSessionResponse::getStatus, YdbQuery.DeleteSessionResponse::getIssuesList);
    private final QueryServiceRpc rpc;
    private final String sessionId;
    private final long nodeID;
    private final boolean isTraceEnabled;
    private final AtomicReference<TransactionImpl> transaction;

    SessionImpl(QueryServiceRpc rpc, YdbQuery.CreateSessionResponse response) {
        this.rpc = rpc;
        this.sessionId = response.getSessionId();
        this.nodeID = SessionImpl.getNodeBySessionId(response.getSessionId(), response.getNodeId());
        this.isTraceEnabled = logger.isTraceEnabled();
        this.transaction = new AtomicReference<TransactionImpl>(new TransactionImpl(TxMode.SERIALIZABLE_RW, null));
    }

    private static Long getNodeBySessionId(String sessionId, long defaultValue) {
        try {
            Map params = URITools.splitQuery((URI)new URI(sessionId));
            List nodeParam = (List)params.get("node_id");
            if (nodeParam != null && !nodeParam.isEmpty()) {
                return Long.parseUnsignedLong((String)nodeParam.get(0));
            }
        }
        catch (RuntimeException | URISyntaxException exception) {
            // empty catch block
        }
        return defaultValue;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    public String toString() {
        return "QuerySessionStream[" + this.sessionId + "]";
    }

    @Override
    public QueryTransaction currentTransaction() {
        return this.transaction.get();
    }

    @Override
    public QueryTransaction createNewTransaction(TxMode txMode) {
        return this.updateTransaction(new TransactionImpl(txMode, null));
    }

    public abstract void updateSessionState(Status var1);

    @Override
    public CompletableFuture<Result<QueryTransaction>> beginTransaction(TxMode tx, BeginTransactionSettings settings) {
        YdbQuery.BeginTransactionRequest request = YdbQuery.BeginTransactionRequest.newBuilder().setSessionId(this.sessionId).setTxSettings(TxControl.txSettings(tx)).build();
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.rpc.beginTransaction(request, grpcSettings).thenApply(result -> {
            this.updateSessionState(result.getStatus());
            return result.map(resp -> this.updateTransaction(new TransactionImpl(tx, resp.getTxMeta().getId())));
        });
    }

    private QueryTransaction updateTransaction(TransactionImpl newTx) {
        TransactionImpl oldTx = this.transaction.getAndSet(newTx);
        if (oldTx != null && oldTx.isActive()) {
            logger.warn("{} lost active transaction {}!!", (Object)this, (Object)oldTx);
        }
        return newTx;
    }

    GrpcReadStream<Status> attach(AttachSessionSettings settings) {
        YdbQuery.AttachSessionRequest request = YdbQuery.AttachSessionRequest.newBuilder().setSessionId(this.sessionId).build();
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings(settings);
        return new ProxyReadStream(this.rpc.attachSession(request, grpcSettings), (message, promise, observer) -> {
            logger.trace("session '{}' got attach stream message {}", (Object)this.sessionId, (Object)TextFormat.shortDebugString((MessageOrBuilder)message));
            Status status = Status.of((StatusCode)StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)message.getStatus()), (Issue[])Issue.fromPb((List)message.getIssuesList()));
            this.updateSessionState(status);
            observer.onNext((Object)status);
        });
    }

    private GrpcRequestSettings makeGrpcRequestSettings(BaseRequestSettings settings) {
        String traceId = settings.getTraceId() == null ? UUID.randomUUID().toString() : settings.getTraceId();
        return GrpcRequestSettings.newBuilder().withDeadline(settings.getRequestTimeout()).withPreferredNodeID(Integer.valueOf((int)this.nodeID)).withTraceId(traceId).build();
    }

    private static YdbQuery.ExecMode mapExecMode(QueryExecMode mode) {
        switch (mode) {
            case EXECUTE: {
                return YdbQuery.ExecMode.EXEC_MODE_EXECUTE;
            }
            case EXPLAIN: {
                return YdbQuery.ExecMode.EXEC_MODE_EXPLAIN;
            }
            case PARSE: {
                return YdbQuery.ExecMode.EXEC_MODE_PARSE;
            }
            case VALIDATE: {
                return YdbQuery.ExecMode.EXEC_MODE_VALIDATE;
            }
        }
        return YdbQuery.ExecMode.EXEC_MODE_UNSPECIFIED;
    }

    private static YdbQuery.StatsMode mapStatsMode(QueryStatsMode mode) {
        switch (mode) {
            case NONE: {
                return YdbQuery.StatsMode.STATS_MODE_NONE;
            }
            case BASIC: {
                return YdbQuery.StatsMode.STATS_MODE_BASIC;
            }
            case FULL: {
                return YdbQuery.StatsMode.STATS_MODE_FULL;
            }
            case PROFILE: {
                return YdbQuery.StatsMode.STATS_MODE_PROFILE;
            }
        }
        return YdbQuery.StatsMode.STATS_MODE_UNSPECIFIED;
    }

    GrpcReadStream<YdbQuery.ExecuteQueryResponsePart> createGrpcStream(String query, YdbQuery.TransactionControl tx, Params prms, ExecuteQuerySettings settings) {
        YdbQuery.ExecuteQueryRequest.Builder requestBuilder = YdbQuery.ExecuteQueryRequest.newBuilder().setSessionId(this.sessionId).setExecMode(SessionImpl.mapExecMode(settings.getExecMode())).setStatsMode(SessionImpl.mapStatsMode(settings.getStatsMode())).setQueryContent(YdbQuery.QueryContent.newBuilder().setSyntax(YdbQuery.Syntax.SYNTAX_YQL_V1).setText(query).build()).putAllParameters(prms.toPb());
        if (tx != null) {
            requestBuilder.setTxControl(tx);
        }
        YdbQuery.ExecuteQueryRequest request = requestBuilder.build();
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings(settings);
        return this.rpc.executeQuery(request, grpcSettings);
    }

    @Override
    public QueryStream createQuery(String query, TxMode tx, Params prms, ExecuteQuerySettings settings) {
        YdbQuery.TransactionControl tc = TxControl.txModeCtrl(tx, true);
        return new StreamImpl((GrpcReadStream)this.createGrpcStream(query, tc, prms, settings)){

            @Override
            void handleTxMeta(YdbQuery.TransactionMeta meta) {
                String txID;
                String string = txID = meta == null ? null : meta.getId();
                if (txID != null && !txID.isEmpty()) {
                    logger.warn("{} got unexpected transaction id {}", (Object)SessionImpl.this, (Object)txID);
                }
            }
        };
    }

    public CompletableFuture<Result<YdbQuery.DeleteSessionResponse>> delete(DeleteSessionSettings settings) {
        YdbQuery.DeleteSessionRequest request = YdbQuery.DeleteSessionRequest.newBuilder().setSessionId(this.sessionId).build();
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings);
        return this.rpc.deleteSession(request, grpcSettings).thenApply((Function)DELETE_SESSION);
    }

    static CompletableFuture<Result<YdbQuery.CreateSessionResponse>> createSession(QueryServiceRpc rpc, CreateSessionSettings settings, boolean useServerBalancer) {
        YdbQuery.CreateSessionRequest request = YdbQuery.CreateSessionRequest.newBuilder().build();
        String traceId = settings.getTraceId() == null ? UUID.randomUUID().toString() : settings.getTraceId();
        GrpcRequestSettings.Builder grpcSettingsBuilder = GrpcRequestSettings.newBuilder().withDeadline(settings.getRequestTimeout()).withTraceId(traceId);
        if (useServerBalancer) {
            grpcSettingsBuilder.addClientCapability(SERVER_BALANCER_HINT);
        }
        return rpc.createSession(request, grpcSettingsBuilder.build()).thenApply((Function)CREATE_SESSION);
    }

    class TransactionImpl
    extends YdbTransactionImpl
    implements QueryTransaction {
        TransactionImpl(TxMode txMode, String txId) {
            super(txMode, txId);
        }

        public String getSessionId() {
            return SessionImpl.this.sessionId;
        }

        @Override
        public QuerySession getSession() {
            return SessionImpl.this;
        }

        @Override
        public QueryStream createQuery(String query, final boolean commitAtEnd, Params prms, ExecuteQuerySettings settings) {
            final CompletableFuture currentStatusFuture = commitAtEnd ? this.statusFuture.getAndSet(new CompletableFuture()) : (CompletableFuture)this.statusFuture.get();
            final String currentId = (String)this.txId.get();
            YdbQuery.TransactionControl tc = currentId != null ? TxControl.txIdCtrl(currentId, commitAtEnd) : TxControl.txModeCtrl(this.txMode, commitAtEnd);
            return new StreamImpl(SessionImpl.this.createGrpcStream(query, tc, prms, settings)){

                @Override
                void handleTxMeta(YdbQuery.TransactionMeta meta) {
                    String newId;
                    String string = newId = meta == null || meta.getId() == null || meta.getId().isEmpty() ? null : meta.getId();
                    if (!TransactionImpl.this.txId.compareAndSet(currentId, newId)) {
                        logger.warn("{} lost transaction meta id {}", (Object)SessionImpl.this, (Object)newId);
                    }
                }

                @Override
                void handleCompletion(Status status, Throwable th) {
                    if (th != null) {
                        currentStatusFuture.completeExceptionally(new RuntimeException("Query on transaction failed with exception ", th));
                    }
                    if (status.isSuccess()) {
                        if (commitAtEnd) {
                            currentStatusFuture.complete(Status.SUCCESS);
                        }
                    } else {
                        currentStatusFuture.complete(Status.of((StatusCode)StatusCode.ABORTED).withIssues(new Issue[]{Issue.of((String)("Query on transaction failed with status " + status), (Issue.Severity)Issue.Severity.ERROR)}));
                    }
                }
            };
        }

        @Override
        public CompletableFuture<Result<QueryInfo>> commit(CommitTransactionSettings settings) {
            CompletableFuture currentStatusFuture = this.statusFuture.getAndSet(new CompletableFuture());
            String transactionId = (String)this.txId.get();
            if (transactionId == null) {
                Issue issue = Issue.of((String)"Transaction is not started", (Issue.Severity)Issue.Severity.WARNING);
                Result res2 = Result.success((Object)new QueryInfo(null), (Status)Status.of((StatusCode)StatusCode.SUCCESS, (Issue[])new Issue[]{issue}));
                return CompletableFuture.completedFuture(res2);
            }
            YdbQuery.CommitTransactionRequest request = YdbQuery.CommitTransactionRequest.newBuilder().setSessionId(SessionImpl.this.sessionId).setTxId(transactionId).build();
            GrpcRequestSettings grpcSettings = SessionImpl.this.makeGrpcRequestSettings((BaseRequestSettings)settings);
            return ((CompletableFuture)SessionImpl.this.rpc.commitTransaction(request, grpcSettings).thenApply(res -> {
                Status status = res.getStatus();
                currentStatusFuture.complete(status);
                SessionImpl.this.updateSessionState(status);
                if (!this.txId.compareAndSet(transactionId, null)) {
                    logger.warn("{} lost commit response for transaction {}", (Object)SessionImpl.this, (Object)transactionId);
                }
                return res.map(resp -> new QueryInfo(null));
            })).whenComplete((status, th) -> {
                if (th != null) {
                    currentStatusFuture.completeExceptionally(new RuntimeException("Transaction commit failed with exception", (Throwable)th));
                }
            });
        }

        @Override
        public CompletableFuture<Status> rollback(RollbackTransactionSettings settings) {
            CompletableFuture currentStatusFuture = this.statusFuture.getAndSet(new CompletableFuture());
            String transactionId = (String)this.txId.get();
            if (transactionId == null) {
                Issue issue = Issue.of((String)"Transaction is not started", (Issue.Severity)Issue.Severity.WARNING);
                return CompletableFuture.completedFuture(Status.of((StatusCode)StatusCode.SUCCESS, (Issue[])new Issue[]{issue}));
            }
            YdbQuery.RollbackTransactionRequest request = YdbQuery.RollbackTransactionRequest.newBuilder().setSessionId(SessionImpl.this.sessionId).setTxId(transactionId).build();
            GrpcRequestSettings grpcSettings = SessionImpl.this.makeGrpcRequestSettings((BaseRequestSettings)settings);
            return ((CompletableFuture)SessionImpl.this.rpc.rollbackTransaction(request, grpcSettings).thenApply(result -> {
                SessionImpl.this.updateSessionState(result.getStatus());
                if (!this.txId.compareAndSet(transactionId, null)) {
                    logger.warn("{} lost rollback response for transaction {}", (Object)SessionImpl.this, (Object)transactionId);
                }
                return result.getStatus();
            })).whenComplete((status, th) -> currentStatusFuture.complete(Status.of((StatusCode)StatusCode.ABORTED).withIssues(new Issue[]{Issue.of((String)"Transaction was rolled back", (Issue.Severity)Issue.Severity.ERROR)})));
        }
    }

    abstract class StreamImpl
    implements QueryStream {
        private final GrpcReadStream<YdbQuery.ExecuteQueryResponsePart> grpcStream;

        StreamImpl(GrpcReadStream<YdbQuery.ExecuteQueryResponsePart> grpcStream) {
            this.grpcStream = grpcStream;
        }

        abstract void handleTxMeta(YdbQuery.TransactionMeta var1);

        void handleCompletion(Status status, Throwable th) {
        }

        @Override
        public CompletableFuture<Result<QueryInfo>> execute(QueryStream.PartsHandler handler) {
            CompletableFuture<Result<QueryInfo>> result = new CompletableFuture<Result<QueryInfo>>();
            AtomicReference stats = new AtomicReference();
            this.grpcStream.start(msg -> {
                QueryStats old;
                if (SessionImpl.this.isTraceEnabled) {
                    logger.trace("{} got stream message {}", (Object)SessionImpl.this, (Object)TextFormat.shortDebugString((MessageOrBuilder)msg));
                }
                Status status = Status.of((StatusCode)StatusCode.fromProto((StatusCodesProtos.StatusIds.StatusCode)msg.getStatus()), (Issue[])Issue.fromPb((List)msg.getIssuesList()));
                SessionImpl.this.updateSessionState(status);
                if (!status.isSuccess()) {
                    this.handleTxMeta(null);
                    result.complete(Result.fail((Status)status));
                    return;
                }
                if (msg.hasTxMeta()) {
                    this.handleTxMeta(msg.getTxMeta());
                }
                if (msg.hasExecStats() && (old = stats.getAndSet(new QueryStats(msg.getExecStats()))) != null) {
                    logger.warn("{} got lost previous exec stats {}", (Object)SessionImpl.this, (Object)old);
                }
                if (msg.hasResultSet()) {
                    long index = msg.getResultSetIndex();
                    if (handler != null) {
                        handler.onNextPart(new QueryResultPart(index, msg.getResultSet()));
                    } else {
                        logger.warn("{} got lost result set part with index {}", (Object)SessionImpl.this, (Object)index);
                    }
                }
            }).whenComplete((status, th) -> {
                this.handleCompletion((Status)status, (Throwable)th);
                if (th != null) {
                    result.completeExceptionally((Throwable)th);
                }
                if (status != null) {
                    if (status.isSuccess()) {
                        result.complete(Result.success((Object)new QueryInfo((QueryStats)stats.get()), (Status)status));
                    } else {
                        result.complete(Result.fail((Status)status));
                    }
                }
            });
            return result;
        }

        @Override
        public void cancel() {
            this.grpcStream.cancel();
        }
    }
}

