/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.query.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import tech.ydb.core.Result;
import tech.ydb.query.QueryStream;
import tech.ydb.query.result.QueryInfo;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.Type;

public class QueryReader
implements Iterable<ResultSetReader> {
    private final QueryInfo info;
    private final List<ResultSetParts> results;

    private QueryReader(QueryInfo info, List<ResultSetParts> results) {
        this.info = info;
        this.results = results;
    }

    public QueryInfo getQueryInfo() {
        return this.info;
    }

    public int getResultSetCount() {
        return this.results.size();
    }

    public ResultSetReader getResultSet(int index) {
        return new CompositeResultSet(this.results.get(index).getParts());
    }

    public static CompletableFuture<Result<QueryReader>> readFrom(QueryStream stream) {
        PartsCollector collector = new PartsCollector();
        return stream.execute(collector).thenApply(res -> res.map(collector::toReader));
    }

    @Override
    public Iterator<ResultSetReader> iterator() {
        return new IteratorImpl(this.results.iterator());
    }

    private static class CompositeResultSet
    implements ResultSetReader {
        private final List<ResultSetReader> parts;
        private final int rowsCount;
        private int partIndex = -1;

        CompositeResultSet(List<QueryResultPart> list) {
            this.parts = list.stream().map(QueryResultPart::getResultSetReader).collect(Collectors.toList());
            this.rowsCount = list.stream().mapToInt(QueryResultPart::getResultSetRowsCount).sum();
            this.partIndex = this.parts.isEmpty() ? -1 : 0;
        }

        public boolean isTruncated() {
            return false;
        }

        public int getColumnCount() {
            if (this.partIndex < 0) {
                return 0;
            }
            return this.parts.get(this.partIndex).getColumnCount();
        }

        public String getColumnName(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts.get(this.partIndex).getColumnName(index);
        }

        public int getColumnIndex(String name) {
            if (this.partIndex < 0) {
                return -1;
            }
            return this.parts.get(this.partIndex).getColumnIndex(name);
        }

        public ValueReader getColumn(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts.get(this.partIndex).getColumn(index);
        }

        public ValueReader getColumn(String name) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts.get(this.partIndex).getColumn(name);
        }

        public Type getColumnType(int index) {
            if (this.partIndex < 0) {
                return null;
            }
            return this.parts.get(this.partIndex).getColumnType(index);
        }

        public int getRowCount() {
            return this.rowsCount;
        }

        public void setRowIndex(int index) {
            this.partIndex = 0;
            int currentIdx = index;
            while (this.partIndex < this.parts.size()) {
                int readerRows = this.parts.get(this.partIndex).getRowCount();
                if (currentIdx < readerRows) {
                    this.parts.get(this.partIndex).setRowIndex(currentIdx);
                    return;
                }
                this.parts.get(this.partIndex).setRowIndex(readerRows - 1);
                currentIdx -= readerRows;
                ++this.partIndex;
            }
        }

        public boolean next() {
            if (this.partIndex < 0) {
                return false;
            }
            boolean res = this.parts.get(this.partIndex).next();
            while (!res && this.partIndex < this.parts.size() - 1) {
                ++this.partIndex;
                res = this.parts.get(this.partIndex).next();
            }
            return res;
        }
    }

    private static class ResultSetParts {
        private final long resultSetIndex;
        private final List<QueryResultPart> parts = new ArrayList<QueryResultPart>();

        ResultSetParts(long index) {
            this.resultSetIndex = index;
        }

        public void addPart(QueryResultPart part) {
            this.parts.add(part);
        }

        public long getIndex() {
            return this.resultSetIndex;
        }

        public List<QueryResultPart> getParts() {
            return this.parts;
        }
    }

    private static class PartsCollector
    implements QueryStream.PartsHandler {
        private final SortedMap<Long, ResultSetParts> results = new TreeMap<Long, ResultSetParts>();

        private PartsCollector() {
        }

        QueryReader toReader(QueryInfo info) {
            ArrayList<ResultSetParts> ordered = new ArrayList<ResultSetParts>();
            long lastInserted = 0L;
            for (Map.Entry<Long, ResultSetParts> entry : this.results.entrySet()) {
                long key = entry.getKey();
                while (lastInserted < key) {
                    ordered.add(new ResultSetParts(lastInserted));
                    ++lastInserted;
                }
                ordered.add(entry.getValue());
                lastInserted = key;
            }
            return new QueryReader(info, ordered);
        }

        @Override
        public void onNextPart(QueryResultPart part) {
            Long index = part.getResultSetIndex();
            if (!this.results.containsKey(index)) {
                this.results.put(index, new ResultSetParts(index));
            }
            ((ResultSetParts)this.results.get(index)).addPart(part);
        }
    }

    private class IteratorImpl
    implements Iterator<ResultSetReader> {
        private final Iterator<ResultSetParts> iter;

        IteratorImpl(Iterator<ResultSetParts> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ResultSetReader next() {
            return new CompositeResultSet(this.iter.next().getParts());
        }
    }
}

