/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.internal.DnsNameResolverProvider;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.stub.MetadataUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.grpc.YdbHeaders;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.core.ssl.YandexTrustManagerFactory;

public class ShadedNettyChannelFactory
implements ManagedChannelFactory {
    static final int INBOUND_MESSAGE_SIZE = 0x4000000;
    static final String DEFAULT_BALANCER_POLICY = "round_robin";
    private final String database;
    private final String version;
    private final boolean useTLS;
    private final byte[] cert;
    private final boolean retryEnabled;
    private final long connectTimeoutMs;
    private final boolean useDefaultGrpcResolver;
    private final Long grpcKeepAliveTimeMillis;

    public ShadedNettyChannelFactory(GrpcTransportBuilder builder) {
        this.database = builder.getDatabase();
        this.version = builder.getVersionString();
        this.useTLS = builder.getUseTls();
        this.cert = builder.getCert();
        this.retryEnabled = builder.isEnableRetry();
        this.connectTimeoutMs = builder.getConnectTimeoutMillis();
        this.useDefaultGrpcResolver = builder.useDefaultGrpcResolver();
        this.grpcKeepAliveTimeMillis = builder.getGrpcKeepAliveTimeMillis();
    }

    @Override
    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Override
    public ManagedChannel newManagedChannel(String host, int port, String sslHostOverride) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
        if (this.useTLS) {
            channelBuilder.negotiationType(NegotiationType.TLS).sslContext(this.createSslContext());
            if (sslHostOverride != null) {
                channelBuilder.overrideAuthority(sslHostOverride);
            }
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        channelBuilder.maxInboundMessageSize(0x4000000).withOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT).intercept(new ClientInterceptor[]{this.metadataInterceptor()});
        if (!this.useDefaultGrpcResolver) {
            ((NettyChannelBuilder)channelBuilder.nameResolverFactory((NameResolver.Factory)new DnsNameResolverProvider())).defaultLoadBalancingPolicy(DEFAULT_BALANCER_POLICY);
        }
        if (this.grpcKeepAliveTimeMillis != null) {
            channelBuilder.keepAliveTime(this.grpcKeepAliveTimeMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.retryEnabled) {
            channelBuilder.enableRetry();
        } else {
            channelBuilder.disableRetry();
        }
        this.configure(channelBuilder);
        return channelBuilder.build();
    }

    protected void configure(NettyChannelBuilder channelBuilder) {
    }

    private ClientInterceptor metadataInterceptor() {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(YdbHeaders.DATABASE, (Object)this.database);
        extraHeaders.put(YdbHeaders.BUILD_INFO, (Object)this.version);
        return MetadataUtils.newAttachHeadersInterceptor((Metadata)extraHeaders);
    }

    private SslContext createSslContext() {
        try {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.cert != null) {
                sslContextBuilder.trustManager((InputStream)new ByteArrayInputStream(this.cert));
            } else {
                sslContextBuilder.trustManager((TrustManagerFactory)new YandexTrustManagerFactory(""));
            }
            return sslContextBuilder.build();
        }
        catch (RuntimeException | SSLException e) {
            throw new RuntimeException("cannot create ssl context", e);
        }
    }

    public static ManagedChannelFactory.Builder build() {
        return new ManagedChannelFactory.Builder(){

            @Override
            public ManagedChannelFactory buildFactory(GrpcTransportBuilder builder) {
                return new ShadedNettyChannelFactory(builder);
            }

            public String toString() {
                return "ShadedNettyChannelFactory";
            }
        };
    }

    public static ManagedChannelFactory.Builder withInterceptor(final Consumer<NettyChannelBuilder> ci) {
        return builder -> new ShadedNettyChannelFactory(builder){

            @Override
            protected void configure(NettyChannelBuilder channelBuilder) {
                if (ci != null) {
                    ci.accept(channelBuilder);
                }
            }
        };
    }
}

