/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.impl.pool.EndpointRecord;

public class PriorityPicker {
    private static final Logger logger = LoggerFactory.getLogger(PriorityPicker.class);
    private static final int LOCALITY_SHIFT = 1000;
    private static final int DETECT_DC_NODE_SIZE = 3;
    private static final int DETECT_DC_TCP_PING_TIMEOUT_MS = 5000;
    private final String prefferedLocation;

    private PriorityPicker(String location) {
        this.prefferedLocation = location;
    }

    public int getEndpointPriority(String location) {
        if (this.prefferedLocation == null || this.prefferedLocation.equalsIgnoreCase(location)) {
            return 0;
        }
        return 1000;
    }

    public static PriorityPicker from(BalancingSettings settings, String selfLocation, List<EndpointRecord> endpoints) {
        switch (settings.getPolicy()) {
            case USE_ALL_NODES: {
                return new PriorityPicker(null);
            }
            case USE_PREFERABLE_LOCATION: {
                return new PriorityPicker(PriorityPicker.getLocationFromConfig(settings.getPreferableLocation(), selfLocation));
            }
            case USE_DETECT_LOCAL_DC: {
                return new PriorityPicker(PriorityPicker.detectLocalDC(endpoints, Ticker.systemTicker()));
            }
        }
        throw new RuntimeException("Not implemented balancing policy: " + settings.getPolicy().name());
    }

    @VisibleForTesting
    static String getLocationFromConfig(String prefferable, String selfLocation) {
        if (prefferable != null && !prefferable.isEmpty()) {
            return prefferable;
        }
        if (selfLocation != null && !selfLocation.isEmpty()) {
            return selfLocation;
        }
        return null;
    }

    @VisibleForTesting
    static String detectLocalDC(List<EndpointRecord> endpoints, Ticker ticker) {
        Map<String, List<EndpointRecord>> dcLocationToNodes = endpoints.stream().collect(Collectors.groupingBy(EndpointRecord::getLocation));
        if (dcLocationToNodes.size() < 2) {
            return null;
        }
        long minPing = Long.MAX_VALUE;
        String localDC = null;
        for (Map.Entry<String, List<EndpointRecord>> entry : dcLocationToNodes.entrySet()) {
            String dc = entry.getKey();
            List<EndpointRecord> nodes = entry.getValue();
            assert (!nodes.isEmpty());
            Collections.shuffle(nodes);
            int nodeSize = Math.min(nodes.size(), 3);
            long tcpPing = 0L;
            for (EndpointRecord node : nodes.subList(0, nodeSize)) {
                long currentPing = PriorityPicker.tcpPing(new InetSocketAddress(node.getHost(), node.getPort()), ticker);
                logger.debug("Address: {}, port: {}, nanos ping: {}", new Object[]{node.getHost(), node.getPort(), currentPing});
                tcpPing += currentPing;
            }
            if (minPing <= (tcpPing /= (long)nodeSize)) continue;
            minPing = tcpPing;
            localDC = dc;
        }
        return localDC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long tcpPing(InetSocketAddress socketAddress, Ticker ticker) {
        try (Socket socket = new Socket();){
            long startConnection = ticker.read();
            socket.connect(socketAddress, 5000);
            long stopConnection = ticker.read();
            long l = stopConnection - startConnection;
            return l;
        }
        catch (IOException e) {
            return Long.MAX_VALUE;
        }
    }
}

