/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultiX509TrustManager
implements X509TrustManager {
    private static final Logger logger = LoggerFactory.getLogger(MultiX509TrustManager.class);
    final List<X509TrustManager> trustManagers;

    MultiX509TrustManager(List<X509TrustManager> trustManagers) {
        this.trustManagers = trustManagers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(x509Certificates, authType);
                return;
            }
            catch (CertificateException ignored) {
                logger.trace("cannot use trust manager {}", (Object)trustManager, (Object)ignored);
            }
        }
        throw new CertificateException("No trust manager trusts this certificates");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(x509Certificates, authType);
                return;
            }
            catch (CertificateException ignored) {
                logger.trace("cannot use trust manager {}", (Object)trustManager, (Object)ignored);
            }
        }
        throw new CertificateException("No trust manager trusts this certificates");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagers) {
            acceptedIssuers.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return acceptedIssuers.toArray(new X509Certificate[0]);
    }
}

