/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.operation;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.function.Function;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.operation.FailedOperation;
import tech.ydb.core.operation.Operation;
import tech.ydb.core.operation.OperationImpl;
import tech.ydb.proto.OperationProtos;

public class OperationBinder {
    @VisibleForTesting
    static final Status UNEXPECTED_ASYNC = Status.of(StatusCode.CLIENT_INTERNAL_ERROR).withIssues(Issue.of("Unexpected async result of operation", Issue.Severity.ERROR));

    private OperationBinder() {
    }

    private static Status status(OperationProtos.Operation operation) {
        StatusCode code = StatusCode.fromProto(operation.getStatus());
        Double consumedRu = null;
        if (operation.hasCostInfo()) {
            consumedRu = operation.getCostInfo().getConsumedUnits();
        }
        return Status.of(code, consumedRu, Issue.fromPb(operation.getIssuesList()));
    }

    private static <M extends Message> Result<M> result(OperationProtos.Operation operation, Class<M> resultClass) {
        Status status = OperationBinder.status(operation);
        if (!status.isSuccess()) {
            return Result.fail(status);
        }
        try {
            Message resultMessage = operation.getResult().unpack(resultClass);
            return Result.success(resultMessage, status);
        }
        catch (InvalidProtocolBufferException ex) {
            return Result.error("Can't unpack message " + resultClass.getName(), ex);
        }
    }

    public static <R, M extends Message> Function<Result<R>, Result<M>> bindSync(Function<R, OperationProtos.Operation> method, Class<M> resultClass) {
        return result -> {
            if (!result.isSuccess()) {
                return result.map(r -> null);
            }
            OperationProtos.Operation operation = (OperationProtos.Operation)method.apply(result.getValue());
            if (!operation.getReady()) {
                return Result.fail(UNEXPECTED_ASYNC);
            }
            return OperationBinder.result(operation, resultClass);
        };
    }

    public static <R> Function<Result<R>, Status> bindSync(Function<R, OperationProtos.Operation> method) {
        return result -> {
            if (!result.isSuccess()) {
                return result.getStatus();
            }
            OperationProtos.Operation operation = (OperationProtos.Operation)method.apply(result.getValue());
            if (!operation.getReady()) {
                return UNEXPECTED_ASYNC;
            }
            return OperationBinder.status(operation);
        };
    }

    public static <R> Function<Result<R>, Operation<Status>> bindAsync(GrpcTransport transport, Function<R, OperationProtos.Operation> method) {
        return result -> {
            if (!result.isSuccess()) {
                Status status = result.getStatus();
                return new FailedOperation<Status>(status, status);
            }
            OperationProtos.Operation operation = (OperationProtos.Operation)method.apply(result.getValue());
            return new OperationImpl<Status>(transport, operation, OperationBinder::status);
        };
    }

    public static <R, M extends Message> Function<Result<R>, Operation<Result<M>>> bindAsync(GrpcTransport transport, Function<R, OperationProtos.Operation> method, Class<M> resultClass) {
        return result -> {
            if (!result.isSuccess()) {
                Status status = result.getStatus();
                return new FailedOperation(Result.fail(status), status);
            }
            OperationProtos.Operation operation = (OperationProtos.Operation)method.apply(result.getValue());
            return new OperationImpl<Result>(transport, operation, o -> OperationBinder.result(o, resultClass));
        };
    }
}

