/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;

public final class GrpcStatuses {
    private static final Logger logger = LoggerFactory.getLogger(GrpcStatuses.class);

    private GrpcStatuses() {
    }

    public static <T> Result<T> toResult(io.grpc.Status status) {
        assert (!status.isOk());
        return Result.fail(GrpcStatuses.toStatus(status));
    }

    public static Status toStatus(io.grpc.Status status) {
        if (status.isOk()) {
            return Status.SUCCESS;
        }
        Issue message = Issue.of(GrpcStatuses.getMessage(status), Issue.Severity.ERROR);
        StatusCode code = GrpcStatuses.getStatusCode(status.getCode());
        Throwable cause = status.getCause();
        if (cause == null) {
            return Status.of(code, cause, message);
        }
        return Status.of(code, cause, message, Issue.of(cause.toString(), Issue.Severity.ERROR));
    }

    private static String getMessage(io.grpc.Status status) {
        if (status.getCode() == Status.Code.CANCELLED) {
            logger.debug("gRPC cancellation: {}, {}", (Object)status.getCode(), (Object)status.getDescription());
        } else {
            logger.warn("gRPC issue: {}, {}", (Object)status.getCode(), (Object)status.getDescription());
        }
        String message = "gRPC error: (" + status.getCode() + ')';
        return status.getDescription() == null ? message : message + ' ' + status.getDescription();
    }

    private static StatusCode getStatusCode(Status.Code code) {
        switch (code) {
            case UNAVAILABLE: {
                return StatusCode.TRANSPORT_UNAVAILABLE;
            }
            case UNAUTHENTICATED: {
                return StatusCode.CLIENT_UNAUTHENTICATED;
            }
            case CANCELLED: {
                return StatusCode.CLIENT_CANCELLED;
            }
            case UNIMPLEMENTED: {
                return StatusCode.CLIENT_CALL_UNIMPLEMENTED;
            }
            case DEADLINE_EXCEEDED: {
                return StatusCode.CLIENT_DEADLINE_EXCEEDED;
            }
            case RESOURCE_EXHAUSTED: {
                return StatusCode.CLIENT_RESOURCE_EXHAUSTED;
            }
        }
        return StatusCode.CLIENT_GRPC_ERROR;
    }
}

