/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.auth;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.auth.AuthIdentity;

public class BackgroundIdentity
implements AuthIdentity {
    private static final Logger logger = LoggerFactory.getLogger(BackgroundIdentity.class);
    private final AtomicReference<State> state = new AtomicReference<NullState>(new NullState());
    private final Clock clock;
    private final Rpc rpc;

    public BackgroundIdentity(Clock clock, Rpc rpc) {
        this.clock = clock;
        this.rpc = rpc;
    }

    public void close() {
        this.rpc.close();
    }

    private State updateState(State current, State next) {
        if (this.state.compareAndSet(current, next)) {
            next.init();
        }
        return this.state.get();
    }

    public String getToken() {
        return this.state.get().validate(this.clock.instant()).token();
    }

    private <T> T unwrap(CompletableFuture<T> future) {
        try {
            return future.get(this.rpc.getTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException ex) {
            logger.error("authentication update problem", (Throwable)ex);
            throw new RuntimeException("authentication update problem", ex);
        }
        catch (InterruptedException ex) {
            logger.error("updating of authentication token was interrupted", (Throwable)ex);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private class ErrorState
    implements State {
        private final RuntimeException ex;

        ErrorState(Throwable ex) {
            this.ex = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException("can't login", ex);
        }

        @Override
        public void init() {
        }

        @Override
        public String token() {
            throw this.ex;
        }

        @Override
        public State validate(Instant now) {
            return BackgroundIdentity.this.updateState(this, new SyncLogin()).validate(now);
        }
    }

    private class LoggedInState
    implements State {
        private final Rpc.Token token;

        LoggedInState(Rpc.Token token) {
            this.token = token;
        }

        @Override
        public void init() {
        }

        @Override
        public String token() {
            return this.token.token();
        }

        @Override
        public State validate(Instant now) {
            if (now.isAfter(this.token.expiredAt())) {
                return BackgroundIdentity.this.updateState(this, new SyncLogin()).validate(now);
            }
            if (now.isAfter(this.token.updateAt())) {
                return BackgroundIdentity.this.updateState(this, new BackgroundLogin(this.token));
            }
            return this;
        }
    }

    private class BackgroundLogin
    implements State {
        private final Rpc.Token token;
        private final CompletableFuture<State> future = new CompletableFuture();

        BackgroundLogin(Rpc.Token token) {
            this.token = token;
        }

        @Override
        public void init() {
            BackgroundIdentity.this.rpc.getTokenAsync().whenComplete((nextToken, th) -> {
                if (nextToken != null) {
                    this.future.complete(new LoggedInState((Rpc.Token)nextToken));
                } else {
                    this.future.completeExceptionally((Throwable)th);
                }
            });
        }

        @Override
        public String token() {
            return this.token.token();
        }

        @Override
        public State validate(Instant now) {
            if (this.future.isCompletedExceptionally()) {
                if (now.isAfter(this.token.expiredAt())) {
                    return BackgroundIdentity.this.updateState(this, new SyncLogin()).validate(now);
                }
                return BackgroundIdentity.this.updateState(this, new BackgroundLogin(this.token));
            }
            if (this.future.isDone()) {
                return BackgroundIdentity.this.updateState(this, this.future.join());
            }
            return this;
        }
    }

    private class SyncLogin
    implements State {
        private final CompletableFuture<State> future = new CompletableFuture();

        private SyncLogin() {
        }

        @Override
        public void init() {
            BackgroundIdentity.this.rpc.getTokenAsync().whenComplete((token, th) -> {
                if (token != null) {
                    this.future.complete(new LoggedInState((Rpc.Token)token));
                } else {
                    this.future.complete(new ErrorState((Throwable)th));
                }
            });
        }

        @Override
        public String token() {
            throw new IllegalStateException("Get token for unfinished sync state");
        }

        @Override
        public State validate(Instant now) {
            return BackgroundIdentity.this.updateState(this, (State)BackgroundIdentity.this.unwrap(this.future));
        }
    }

    private class NullState
    implements State {
        private NullState() {
        }

        @Override
        public void init() {
        }

        @Override
        public String token() {
            throw new IllegalStateException("Get token for null state");
        }

        @Override
        public State validate(Instant now) {
            return BackgroundIdentity.this.updateState(this, new SyncLogin()).validate(now);
        }
    }

    private static interface State {
        public void init();

        public State validate(Instant var1);

        public String token();
    }

    public static interface Rpc
    extends AutoCloseable {
        public CompletableFuture<Token> getTokenAsync();

        public int getTimeoutSeconds();

        @Override
        default public void close() {
        }

        public static class Token {
            private final String token;
            private final Instant expiredAt;
            private final Instant updateAt;

            public Token(String token, Instant expiredAt, Instant updateAt) {
                this.token = token;
                this.expiredAt = expiredAt;
                this.updateAt = updateAt;
            }

            public String token() {
                return this.token;
            }

            public Instant expiredAt() {
                return this.expiredAt;
            }

            public Instant updateAt() {
                return this.updateAt;
            }
        }
    }
}

