/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;

public interface Result<T> {
    @Nonnull
    public Status getStatus();

    @Nonnull
    public T getValue() throws UnexpectedResultException;

    @Nonnull
    public <U> Result<U> map(@Nonnull Function<T, U> var1);

    @Nonnull
    public <U> CompletableFuture<Result<U>> mapResultFuture(@Nonnull Function<T, CompletableFuture<Result<U>>> var1);

    @Nonnull
    public CompletableFuture<Status> mapStatusFuture(@Nonnull Function<T, CompletableFuture<Status>> var1);

    default public boolean isSuccess() {
        return this.getStatus().getCode() == StatusCode.SUCCESS;
    }

    public static <V> Result<V> success(@Nonnull V value) {
        return new Success(value, Status.SUCCESS);
    }

    public static <V> Result<V> success(@Nonnull V value, Status status) {
        return new Success(value, Objects.requireNonNull(status));
    }

    public static <V> Result<V> fail(@Nonnull Status status) {
        return new Fail(Objects.requireNonNull(status));
    }

    public static <V> Result<V> fail(UnexpectedResultException unexpected) {
        return new Unexpected(Objects.requireNonNull(unexpected));
    }

    public static <V> Result<V> error(String message, Throwable throwable) {
        if (throwable instanceof UnexpectedResultException) {
            return new Unexpected(message, (UnexpectedResultException)throwable);
        }
        return new Error(message, throwable);
    }

    public static <T, U> Function<Result<T>, CompletableFuture<Result<U>>> compose(Function<T, CompletableFuture<Result<U>>> mapper) {
        return result -> result.mapResultFuture(mapper);
    }

    public static <T> Function<Result<T>, CompletableFuture<Status>> composeStatus(Function<T, CompletableFuture<Status>> mapper) {
        return result -> result.mapStatusFuture(mapper);
    }

    public static <T, U> Function<Result<T>, CompletableFuture<Result<U>>> composeValue(U value) {
        return result -> result.mapResultFuture(v -> CompletableFuture.completedFuture(Result.success(value)));
    }

    public static final class Error<V>
    implements Result<V> {
        private static final Status ERROR = Status.of(StatusCode.CLIENT_INTERNAL_ERROR);
        private final String message;
        private final Status status;

        private Error(String message, Throwable cause) {
            this.message = message;
            this.status = ERROR.withCause(cause);
        }

        @Override
        @Nonnull
        public Status getStatus() {
            return this.status;
        }

        @Override
        @Nonnull
        public V getValue() {
            throw new UnexpectedResultException(this.message, this.status);
        }

        @Override
        @Nonnull
        public <U> Error<U> map(Function<V, U> mapper) {
            return this;
        }

        @Override
        @Nonnull
        public <U> CompletableFuture<Result<U>> mapResultFuture(Function<V, CompletableFuture<Result<U>>> mapper) {
            CompletableFuture<Result<U>> future = new CompletableFuture<Result<U>>();
            future.completeExceptionally(this.status.getCause());
            return future;
        }

        @Override
        @Nonnull
        public CompletableFuture<Status> mapStatusFuture(Function<V, CompletableFuture<Status>> mapper) {
            return CompletableFuture.completedFuture(this.status);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return Objects.equals(this.message, error.message) && Objects.equals(this.status, error.status);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.status);
        }

        public String toString() {
            return "Error{message='" + this.message + "', cause=" + this.status.getCause() + '}';
        }
    }

    public static final class Unexpected<V>
    implements Result<V> {
        private final UnexpectedResultException cause;

        private Unexpected(UnexpectedResultException cause) {
            this.cause = cause;
        }

        private Unexpected(String message, UnexpectedResultException cause) {
            this.cause = message == null || message.isEmpty() ? cause : new UnexpectedResultException(message, cause);
        }

        @Override
        @Nonnull
        public Status getStatus() {
            return this.cause.getStatus();
        }

        @Override
        @Nonnull
        public V getValue() {
            throw this.cause;
        }

        @Override
        @Nonnull
        public <U> Unexpected<U> map(Function<V, U> mapper) {
            return this;
        }

        @Override
        @Nonnull
        public <U> CompletableFuture<Result<U>> mapResultFuture(Function<V, CompletableFuture<Result<U>>> mapper) {
            return CompletableFuture.completedFuture(this);
        }

        @Override
        @Nonnull
        public CompletableFuture<Status> mapStatusFuture(Function<V, CompletableFuture<Status>> mapper) {
            return CompletableFuture.completedFuture(this.cause.getStatus());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unexpected error = (Unexpected)o;
            return Objects.equals(this.cause, error.cause);
        }

        public int hashCode() {
            return Objects.hash(this.cause);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Unexpected{message='").append(this.cause.getMessage()).append("'");
            if (this.cause.getCause() != null) {
                sb.append(", cause=").append(this.cause.getCause());
            }
            return sb.append("}").toString();
        }
    }

    public static final class Fail<V>
    implements Result<V> {
        private final Status status;

        private Fail(Status status) {
            assert (status.getCode() != StatusCode.SUCCESS);
            this.status = status;
        }

        @Override
        @Nonnull
        public <U> Fail<U> map(Function<V, U> mapper) {
            return this;
        }

        @Override
        @Nonnull
        public <U> CompletableFuture<Result<U>> mapResultFuture(Function<V, CompletableFuture<Result<U>>> mapper) {
            return CompletableFuture.completedFuture(this);
        }

        @Override
        @Nonnull
        public CompletableFuture<Status> mapStatusFuture(Function<V, CompletableFuture<Status>> mapper) {
            return CompletableFuture.completedFuture(this.status);
        }

        @Override
        @Nonnull
        public Status getStatus() {
            return this.status;
        }

        @Override
        @Nonnull
        public V getValue() {
            throw new UnexpectedResultException("Cannot get value", this.status);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fail fail = (Fail)o;
            return Objects.equals(this.status, fail.status);
        }

        public int hashCode() {
            return this.status.hashCode();
        }

        public String toString() {
            return "Fail{" + this.status + "}";
        }
    }

    public static final class Success<V>
    implements Result<V> {
        private final V value;
        private final Status status;

        private Success(V value, Status status) {
            assert (status.getCode() == StatusCode.SUCCESS);
            this.value = value;
            this.status = status;
        }

        @Override
        @Nonnull
        public Status getStatus() {
            return this.status;
        }

        @Override
        @Nonnull
        public V getValue() {
            return this.value;
        }

        @Override
        @Nonnull
        public <U> Success<U> map(Function<V, U> mapper) {
            return new Success<U>(mapper.apply(this.value), this.status);
        }

        @Override
        @Nonnull
        public <U> CompletableFuture<Result<U>> mapResultFuture(Function<V, CompletableFuture<Result<U>>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        @Nonnull
        public CompletableFuture<Status> mapStatusFuture(Function<V, CompletableFuture<Status>> mapper) {
            return mapper.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return Objects.equals(this.status, success.status) && Objects.equals(this.value, success.value);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.value);
        }

        public String toString() {
            return "Success{" + this.value + ", status=" + this.status + "}";
        }
    }
}

