/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import tech.ydb.proto.YdbIssueMessage;

@ParametersAreNonnullByDefault
@Immutable
public class Issue
implements Serializable {
    private static final long serialVersionUID = 902460195087723460L;
    public static final Issue[] EMPTY_ARRAY = new Issue[0];
    private final Position position;
    private final Position endPosition;
    private final int code;
    private final String message;
    private final Severity severity;
    private final Issue[] issues;

    private Issue(Position position, Position endPosition, int code, String message, Severity severity, Issue ... issues) {
        this.position = Objects.requireNonNull(position, "position");
        this.endPosition = Objects.requireNonNull(endPosition, "endPosition");
        this.code = code;
        this.message = Objects.requireNonNull(message, "message");
        this.severity = Objects.requireNonNull(severity, "severity");
        this.issues = Objects.requireNonNull(issues, "issues");
    }

    public static Issue of(Position position, Position endPosition, int code, String message, Severity severity, Issue ... issues) {
        return new Issue(position, endPosition, code, message, severity, issues);
    }

    public static Issue of(Position position, Position endPosition, int code, String message, Severity severity) {
        return new Issue(position, endPosition, code, message, severity, EMPTY_ARRAY);
    }

    public static Issue of(Position position, int code, String message, Severity severity) {
        return new Issue(position, Position.EMPTY, code, message, severity, EMPTY_ARRAY);
    }

    public static Issue of(int code, String message, Severity severity) {
        return new Issue(Position.EMPTY, Position.EMPTY, code, message, severity, EMPTY_ARRAY);
    }

    public static Issue of(String message, Severity severity) {
        return new Issue(Position.EMPTY, Position.EMPTY, 0, message, severity, EMPTY_ARRAY);
    }

    public static Issue fromPb(YdbIssueMessage.IssueMessage m) {
        return Issue.of(m.hasPosition() ? Position.fromPb(m.getPosition()) : Position.EMPTY, m.hasEndPosition() ? Position.fromPb(m.getEndPosition()) : Position.EMPTY, m.getIssueCode(), m.getMessage(), Severity.of(m.getSeverity()), Issue.fromPb(m.getIssuesList()));
    }

    public static Issue[] fromPb(List<YdbIssueMessage.IssueMessage> issues) {
        if (issues.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Issue[] arr = new Issue[issues.size()];
        for (int i = 0; i < issues.size(); ++i) {
            arr[i] = Issue.fromPb(issues.get(i));
        }
        return arr;
    }

    public Position getPosition() {
        return this.position;
    }

    public Position getEndPosition() {
        return this.endPosition;
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Issue[] getIssues() {
        return this.issues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return this.code == issue.code && Objects.equals(this.position, issue.position) && Objects.equals(this.endPosition, issue.endPosition) && Objects.equals(this.message, issue.message) && this.severity == issue.severity;
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.endPosition.hashCode();
        result = 31 * result + this.code;
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.severity.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        if (this.position != Position.EMPTY) {
            sb.append(this.position);
            if (this.endPosition != Position.EMPTY) {
                sb.append(" - ");
                sb.append(this.endPosition);
            }
            sb.append(": ");
        }
        if (this.code > 0) {
            sb.append('#').append(this.code).append(' ');
        }
        sb.append(this.message);
        sb.append(" (S_").append((Object)this.severity).append(")\n");
        for (Issue issue : this.issues) {
            sb.append("  ").append(issue.toString()).append('\n');
        }
        sb.setLength(sb.length() - 1);
    }

    @ParametersAreNonnullByDefault
    @Immutable
    public static class Position
    implements Serializable {
        private static final long serialVersionUID = 2809376012140299923L;
        public static final Position EMPTY = new Position(0, 0, "");
        private final int column;
        private final int row;
        private final String file;

        private Position(int column, int row, String file) {
            this.column = column;
            this.row = row;
            this.file = Objects.requireNonNull(file, "file");
        }

        public static Position of(int column, int row) {
            return Position.of(column, row, "");
        }

        public static Position of(int column, int row, String file) {
            if (column == 0 && row == 0 && file.isEmpty()) {
                return EMPTY;
            }
            return new Position(column, row, file);
        }

        private static Position fromPb(YdbIssueMessage.IssueMessage.Position m) {
            return Position.of(m.getColumn(), m.getRow(), m.getFile());
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public String getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.column == position.column && this.row == position.row && Objects.equals(this.file, position.file);
        }

        public int hashCode() {
            int result = this.column;
            result = 31 * result + this.row;
            result = 31 * result + this.file.hashCode();
            return result;
        }

        public String toString() {
            return this.column + ":" + this.row + (this.file.isEmpty() ? "" : " at " + this.file);
        }
    }

    public static enum Severity {
        FATAL(0),
        ERROR(1),
        WARNING(2),
        INFO(3);

        private final int code;

        private Severity(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Severity of(int code) {
            for (Severity s : Severity.values()) {
                if (s.code != code) continue;
                return s;
            }
            return FATAL;
        }
    }
}

