/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.call.GrpcStatusHandler;

public class ReadWriteStreamCall<R, W>
extends ClientCall.Listener<R>
implements GrpcReadWriteStream<R, W> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransport.class);
    private final String traceId;
    private final ClientCall<W, R> call;
    private final Lock callLock = new ReentrantLock();
    private final GrpcStatusHandler statusConsumer;
    private final Metadata headers;
    private final AuthCallOptions callOptions;
    private final CompletableFuture<Status> statusFuture = new CompletableFuture();
    private final AtomicReference<GrpcReadStream.Observer<R>> observerReference = new AtomicReference();
    private final Queue<W> messagesQueue = new ArrayDeque<W>();

    public ReadWriteStreamCall(String traceId, ClientCall<W, R> call, Metadata headers, AuthCallOptions callOptions, GrpcStatusHandler statusConsumer) {
        this.traceId = traceId;
        this.call = call;
        this.headers = headers;
        this.statusConsumer = statusConsumer;
        this.callOptions = callOptions;
    }

    @Override
    public String authToken() {
        return this.callOptions.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Status> start(GrpcReadStream.Observer<R> observer) {
        if (!this.observerReference.compareAndSet(null, observer)) {
            throw new IllegalStateException("Read stream call is already started");
        }
        this.callLock.lock();
        try {
            this.call.start((ClientCall.Listener)this, this.headers);
            this.call.request(1);
        }
        catch (Throwable t) {
            try {
                this.call.cancel(null, t);
            }
            catch (Throwable ex) {
                logger.error("Exception encountered while closing the unary call", ex);
            }
            this.statusFuture.completeExceptionally(t);
        }
        finally {
            this.callLock.unlock();
        }
        return this.statusFuture;
    }

    @Override
    public void sendNext(W message) {
        this.callLock.lock();
        try {
            if (this.flush()) {
                if (logger.isTraceEnabled()) {
                    String msg = TextFormat.shortDebugString((MessageOrBuilder)((Message)message));
                    logger.trace("ReadWriteStreamCall[{}] --> {}", (Object)this.traceId, (Object)msg);
                }
                this.call.sendMessage(message);
            } else {
                this.messagesQueue.add(message);
            }
        }
        finally {
            this.callLock.unlock();
        }
    }

    private boolean flush() {
        while (this.call.isReady()) {
            W next = this.messagesQueue.poll();
            if (next == null) {
                return true;
            }
            if (logger.isTraceEnabled()) {
                String msg = TextFormat.shortDebugString((MessageOrBuilder)((Message)next));
                logger.trace("ReadWriteStreamCall[{}] --> {}", (Object)this.traceId, (Object)msg);
            }
            this.call.sendMessage(next);
        }
        return false;
    }

    @Override
    public void cancel() {
        this.callLock.lock();
        try {
            this.call.cancel("Cancelled on user request", (Throwable)new CancellationException());
        }
        finally {
            this.callLock.unlock();
        }
    }

    public void onMessage(R message) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("ReadWriteStreamCall[{}] <-- {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((MessageOrBuilder)((Message)message)));
            }
            this.observerReference.get().onNext(message);
            this.callLock.lock();
            try {
                this.call.request(1);
            }
            finally {
                this.callLock.unlock();
            }
        }
        catch (Exception ex) {
            this.statusFuture.completeExceptionally(ex);
            try {
                this.callLock.lock();
                try {
                    this.call.cancel("Canceled by exception from observer", (Throwable)ex);
                }
                finally {
                    this.callLock.unlock();
                }
            }
            catch (Throwable th) {
                logger.error("Exception encountered while canceling the read write stream call", th);
            }
        }
    }

    public void onReady() {
        this.callLock.lock();
        try {
            this.flush();
        }
        finally {
            this.callLock.unlock();
        }
    }

    @Override
    public void close() {
        this.callLock.lock();
        try {
            this.call.halfClose();
        }
        finally {
            this.callLock.unlock();
        }
    }

    public void onClose(io.grpc.Status status, @Nullable Metadata trailers) {
        if (logger.isTraceEnabled()) {
            logger.trace("ReadWriteStreamCall[{}] closed with status {}", (Object)this.traceId, (Object)status);
        }
        this.statusConsumer.accept(status, trailers);
        if (status.isOk()) {
            this.statusFuture.complete(Status.SUCCESS);
        } else {
            this.statusFuture.complete(GrpcStatuses.toStatus(status));
        }
    }
}

