/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import tech.ydb.core.Issue;
import tech.ydb.core.Status;

@ParametersAreNonnullByDefault
public class UnexpectedResultException
extends RuntimeException {
    private static final long serialVersionUID = 2450224259821940035L;
    private final Status status;

    public UnexpectedResultException(String message, Status status) {
        super(UnexpectedResultException.formatMessage(message, status), status.getCause());
        this.status = Objects.requireNonNull(status);
    }

    UnexpectedResultException(String message, UnexpectedResultException other) {
        super(message + ": " + other.getMessage(), other.getCause());
        this.status = other.status;
        this.setStackTrace(other.getStackTrace());
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    private static String formatMessage(String message, Status status) {
        Issue[] issues;
        StringBuilder sb = new StringBuilder(64);
        if (!message.isEmpty()) {
            sb.append(message).append(", ");
        }
        sb.append("code: ").append(status.getCode().name());
        if (status.hasConsumedRu()) {
            sb.append(", consumed ").append(status.getConsumedRu()).append(" RU");
        }
        if ((issues = status.getIssues()).length != 0) {
            sb.append(", issues: [");
            for (Issue issue : issues) {
                issue.toString(sb);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }
}

